/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.service;

import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.gritlabs.probe.domain.repository.RecordRepository;
import io.gritlabs.probe.domain.repository.entity.RecordEntity;
import io.gritlabs.probe.domain.service.HttpWebClientServiceImpl;
import io.gritlabs.probe.domain.service.MqttService;
import io.gritlabs.probe.domain.service.TelemetrySinkService;
import io.gritlabs.probe.domain.service.dto.PointDto;
import io.gritlabs.probe.domain.service.dto.PointTypeDto;
import io.gritlabs.probe.domain.service.dto.TelemetryDto;
import io.gritlabs.probe.domain.service.model.RecordModel;
import io.gritlabs.probe.util.Util;
import io.gritlabs.probe.util.VersionHolder;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001BK\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0012J\u0012\u0010+\u001a\u00020*2\b\u0010)\u001a\u0004\u0018\u00010(H\u0012J\u0016\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020*0/H\u0012J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\u0007H\u0012J\u0016\u00103\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020*0/H\u0012J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020*0/H\u0012J\b\u00106\u001a\u00020-H\u0017R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lio/gritlabs/probe/domain/service/TelemetrySinkServiceImpl;", "Lio/gritlabs/probe/domain/service/TelemetrySinkService;", "mqttService", "Lio/gritlabs/probe/domain/service/MqttService;", "httpWebClient", "Lio/gritlabs/probe/domain/service/HttpWebClientServiceImpl;", "instanceId", "", "enableBuffer", "", "bufferReadMax", "", "versionHolder", "Lio/gritlabs/probe/util/VersionHolder;", "repository", "Lio/gritlabs/probe/domain/repository/RecordRepository;", "(Lio/gritlabs/probe/domain/service/MqttService;Lio/gritlabs/probe/domain/service/HttpWebClientServiceImpl;Ljava/lang/String;ZILio/gritlabs/probe/util/VersionHolder;Lio/gritlabs/probe/domain/repository/RecordRepository;)V", "getBufferReadMax", "()I", "setBufferReadMax", "(I)V", "getEnableBuffer", "()Z", "setEnableBuffer", "(Z)V", "executor", "Ljava/util/concurrent/ExecutorService;", "getHttpWebClient", "()Lio/gritlabs/probe/domain/service/HttpWebClientServiceImpl;", "getInstanceId", "()Ljava/lang/String;", "setInstanceId", "(Ljava/lang/String;)V", "log", "Lorg/slf4j/Logger;", "getMqttService", "()Lio/gritlabs/probe/domain/service/MqttService;", "getRepository", "()Lio/gritlabs/probe/domain/repository/RecordRepository;", "mapRecordEntity", "Lio/gritlabs/probe/domain/repository/entity/RecordEntity;", "it", "Lio/gritlabs/probe/domain/service/model/RecordModel;", "mapRecordModel", "persist", "", "records", "", "publish", "telemetry", "Lio/gritlabs/probe/domain/service/dto/TelemetryDto;", "purge", "id", "read", "readBuffer", "grit-probe"})
public class TelemetrySinkServiceImpl
implements TelemetrySinkService {
    private final Logger log;
    private final ExecutorService executor;
    @NotNull
    private final MqttService mqttService;
    @NotNull
    private final HttpWebClientServiceImpl httpWebClient;
    @NotNull
    private String instanceId;
    private boolean enableBuffer;
    private int bufferReadMax;
    private final VersionHolder versionHolder;
    @NotNull
    private final RecordRepository repository;

    public void publish(@NotNull TelemetryDto telemetry) {
        Intrinsics.checkParameterIsNotNull((Object)telemetry, (String)"telemetry");
        this.log.debug("TelemetrySink Publish");
        ((Map)telemetry.getAdditionalData()).put("version", this.versionHolder.getVersion());
        ((Map)telemetry.getAdditionalData()).put("hostname", Util.Companion.getHostname());
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.log.debug("TelemetrySink Publish Complete");
    }

    @Scheduled(initialDelay=30000L, fixedDelay=60000L)
    public synchronized void readBuffer() {
        if (!this.getEnableBuffer()) {
            return;
        }
        try {
            List records = this.read();
            if (records.isEmpty()) {
                this.log.debug("No Buffered Records");
                return;
            }
            this.purge(records);
            Iterable $this$forEach$iv = records;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RecordModel it = (RecordModel)element$iv;
                boolean bl = false;
                this.log.debug("Publish Cached Record");
                try {
                    it.getTelemetry().getMeasurement().getPoints().add(new PointDto("BufferTransmissionDelta", (Object)ChronoUnit.MILLIS.between(it.getCreated(), ZonedDateTime.now()), PointTypeDto.INT32));
                    this.publish(it.getTelemetry());
                }
                catch (Exception e) {
                    this.log.error("Buffer Publish Exception", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Read Exception (Buffer) - " + e.getMessage(), (Throwable)e);
        }
    }

    private void purge(List<RecordModel> records) {
        Object object;
        RecordModel it;
        Object object2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = records;
        RecordRepository recordRepository = this.getRepository();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RecordModel recordModel = (RecordModel)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = this.mapRecordEntity(it);
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        recordRepository.deleteAll((Iterable)object2);
        $this$map$iv = records;
        object2 = new StringBuilder().append("Deleted Records [");
        recordRepository = this.log;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RecordModel)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string = it.getId();
            object.add(string);
        }
        object = (List)destination$iv$iv;
        recordRepository.debug(((StringBuilder)object2).append(object).append(']').toString());
    }

    private RecordEntity mapRecordEntity(RecordModel it) {
        return new RecordEntity(it.getId(), it.getCreated(), it.getUpdated(), it.getDeleted(), ExtensionsKt.jacksonObjectMapper().writeValueAsString((Object)it.getTelemetry()));
    }

    private void purge(String id) {
        this.getRepository().deleteById((Object)id);
        this.log.debug("Deleted Record [" + id + ']');
    }

    private List<RecordModel> read() {
        boolean bl = false;
        List records = new ArrayList();
        RecordRepository recordRepository = this.getRepository();
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.getBufferReadMax());
        Intrinsics.checkExpressionValueIsNotNull((Object)pageRequest, (String)"PageRequest.of(0, bufferReadMax)");
        List pagedRecords = recordRepository.findAllByOrderByCreatedDesc((Pageable)pageRequest);
        this.log.debug("Retrieved [" + pagedRecords.size() + "] from buffer");
        Iterable $this$forEach$iv = pagedRecords;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RecordEntity it = (RecordEntity)element$iv;
            boolean bl2 = false;
            records.add(this.mapRecordModel(it));
        }
        this.log.debug("Mapped [" + records.size() + "] from buffer");
        return records;
    }

    private RecordModel mapRecordModel(RecordEntity it) {
        RecordEntity recordEntity = it;
        if (recordEntity == null) {
            Intrinsics.throwNpe();
        }
        String string = recordEntity.getId();
        ZonedDateTime zonedDateTime = it.getCreated();
        ZonedDateTime zonedDateTime2 = it.getUpdated();
        ZonedDateTime zonedDateTime3 = it.getDeleted();
        Object object = ExtensionsKt.jacksonObjectMapper().readValue(it.getTelemetry(), TelemetryDto.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"jacksonObjectMapper().re\u2026TelemetryDto::class.java)");
        return new RecordModel(string, zonedDateTime, zonedDateTime2, zonedDateTime3, (TelemetryDto)object);
    }

    /*
     * WARNING - void declaration
     */
    private void persist(List<RecordModel> records) {
        Collection<RecordEntity> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!this.getEnableBuffer()) {
            return;
        }
        Iterable iterable = records;
        RecordRepository recordRepository = this.getRepository();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RecordModel recordModel = (RecordModel)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            RecordEntity recordEntity = new RecordEntity(it.getId(), it.getCreated(), it.getUpdated(), it.getDeleted(), it.getTelemetry().toJson());
            collection.add(recordEntity);
        }
        collection = (List)destination$iv$iv;
        recordRepository.saveAll((Iterable)collection);
        this.log.debug("Buffered [" + records.size() + ']');
    }

    @NotNull
    public MqttService getMqttService() {
        return this.mqttService;
    }

    @NotNull
    public HttpWebClientServiceImpl getHttpWebClient() {
        return this.httpWebClient;
    }

    @NotNull
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.instanceId = string;
    }

    public boolean getEnableBuffer() {
        return this.enableBuffer;
    }

    public void setEnableBuffer(boolean bl) {
        this.enableBuffer = bl;
    }

    public int getBufferReadMax() {
        return this.bufferReadMax;
    }

    public void setBufferReadMax(int n) {
        this.bufferReadMax = n;
    }

    @NotNull
    public RecordRepository getRepository() {
        return this.repository;
    }

    public TelemetrySinkServiceImpl(@Autowired @NotNull MqttService mqttService, @Autowired @NotNull HttpWebClientServiceImpl httpWebClient, @Value(value="${grit.instanceId:INVALID}") @NotNull String instanceId, @Value(value="${grit.buffer.enabled:true}") boolean enableBuffer, @Value(value="${grit.buffer.read.max:1000}") int bufferReadMax, @Autowired @NotNull VersionHolder versionHolder, @Autowired @NotNull RecordRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)mqttService, (String)"mqttService");
        Intrinsics.checkParameterIsNotNull((Object)httpWebClient, (String)"httpWebClient");
        Intrinsics.checkParameterIsNotNull((Object)instanceId, (String)"instanceId");
        Intrinsics.checkParameterIsNotNull((Object)versionHolder, (String)"versionHolder");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.mqttService = mqttService;
        this.httpWebClient = httpWebClient;
        this.instanceId = instanceId;
        this.enableBuffer = enableBuffer;
        this.bufferReadMax = bufferReadMax;
        this.versionHolder = versionHolder;
        this.repository = repository;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(this::class.java)");
        this.log = logger;
        ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("sink-"));
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newCachedThrea\u2026leThreadFactory(\"sink-\"))");
        this.executor = executorService;
    }

    public static final /* synthetic */ Logger access$getLog$p(TelemetrySinkServiceImpl $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$persist(TelemetrySinkServiceImpl $this, List records) {
        $this.persist(records);
    }
}

