/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.service;

import io.gritlabs.probe.domain.service.EventDispatcherServiceImpl;
import io.gritlabs.probe.domain.service.MqttService;
import io.gritlabs.probe.domain.service.model.EventListener;
import io.gritlabs.probe.domain.service.model.EventRequestModel;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.fusesource.mqtt.client.FutureConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002BU\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\b\u0012\b\b\u0001\u0010\n\u001a\u00020\b\u0012\b\b\u0001\u0010\u000b\u001a\u00020\u0006\u0012\b\b\u0001\u0010\f\u001a\u00020\b\u0012\b\b\u0001\u0010\r\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eJ\b\u0010&\u001a\u00020'H\u0017J\b\u0010(\u001a\u00020'H\u0017J\b\u0010)\u001a\u00020'H\u0012J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\f\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0092.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012R\u000e\u0010!\u001a\u00020\u0006X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u001a\u0010\r\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0016\u00a8\u00060"}, d2={"Lio/gritlabs/probe/domain/service/MqttServiceImpl;", "Lio/gritlabs/probe/domain/service/MqttService;", "Lio/gritlabs/probe/domain/service/model/EventListener;", "eventDispatcherService", "Lio/gritlabs/probe/domain/service/EventDispatcherServiceImpl;", "enabled", "", "serverUri", "", "username", "password", "retainMessage", "instanceId", "topicBase", "(Lio/gritlabs/probe/domain/service/EventDispatcherServiceImpl;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "connection", "Lorg/fusesource/mqtt/client/FutureConnection;", "getEnabled", "()Z", "getEventDispatcherService", "()Lio/gritlabs/probe/domain/service/EventDispatcherServiceImpl;", "getInstanceId", "()Ljava/lang/String;", "setInstanceId", "(Ljava/lang/String;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "mqtt", "Lorg/fusesource/mqtt/client/MQTT;", "getPassword", "getRetainMessage", "running", "getServerUri", "getTopicBase", "setTopicBase", "getUsername", "destroy", "", "init", "initTopicBase", "onEventReceived", "eventRequest", "Lio/gritlabs/probe/domain/service/model/EventRequestModel;", "publish", "topic", "payload", "grit-probe"})
public class MqttServiceImpl
implements MqttService,
EventListener {
    private boolean running;
    private MQTT mqtt;
    @NotNull
    private final Logger log;
    private FutureConnection connection;
    @NotNull
    private final EventDispatcherServiceImpl eventDispatcherService;
    private final boolean enabled;
    @NotNull
    private final String serverUri;
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    private final boolean retainMessage;
    @NotNull
    private String instanceId;
    @NotNull
    private String topicBase;

    @NotNull
    public Logger getLog() {
        return this.log;
    }

    @PreDestroy
    public void destroy() {
        this.running = false;
    }

    @PostConstruct
    public void init() {
        if (!this.getEnabled()) {
            return;
        }
        EventDispatcherServiceImpl.Companion.getEventBus().register((Object)this);
        this.initTopicBase();
        URI uri = new URI(this.getServerUri());
        MQTT mQTT = this.mqtt = new MQTT();
        if (mQTT == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mqtt");
        }
        mQTT.setHost(uri.getHost(), uri.getPort());
        MQTT mQTT2 = this.mqtt;
        if (mQTT2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mqtt");
        }
        mQTT2.setUserName(this.getUsername());
        MQTT mQTT3 = this.mqtt;
        if (mQTT3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mqtt");
        }
        mQTT3.setPassword(this.getPassword());
        MQTT mQTT4 = this.mqtt;
        if (mQTT4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mqtt");
        }
        FutureConnection futureConnection = mQTT4.futureConnection();
        Intrinsics.checkExpressionValueIsNotNull((Object)futureConnection, (String)"mqtt.futureConnection()");
        this.connection = futureConnection;
        Executors.newSingleThreadExecutor().submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initTopicBase() {
        if (!StringsKt.endsWith$default((String)this.getTopicBase(), (String)"/", (boolean)false, (int)2, null)) {
            this.setTopicBase(this.getTopicBase() + '/');
        }
        this.setTopicBase(this.getTopicBase() + this.getInstanceId() + '/');
        MqttService.Companion.setTopicBase(this.getTopicBase());
    }

    public void publish(@NotNull String topic, @NotNull String payload) {
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        if (!this.getEnabled()) {
            return;
        }
        String qualifiedTopic = topic;
        if (!StringsKt.startsWith$default((String)topic, (String)this.getTopicBase(), (boolean)false, (int)2, null)) {
            qualifiedTopic = this.getTopicBase() + topic;
        }
        FutureConnection futureConnection = this.connection;
        if (futureConnection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
        }
        if (!futureConnection.isConnected()) {
            this.getLog().error("MqttService: Not Connected - [" + this.getServerUri() + "] - Attempting to re-establish. ");
            return;
        }
        try {
            FutureConnection futureConnection2 = this.connection;
            if (futureConnection2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
            }
            String string = payload;
            String string2 = qualifiedTopic;
            FutureConnection futureConnection3 = futureConnection2;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            futureConnection3.publish(string2, byArray2, QoS.AT_LEAST_ONCE, this.getRetainMessage());
            this.getLog().debug("MqttService: Published - [" + qualifiedTopic + "] [" + payload + ']');
        }
        catch (Exception e) {
            this.getLog().error("Publish Exception: [" + e.getMessage() + ']', (Throwable)e);
        }
    }

    public void onEventReceived(@NotNull EventRequestModel eventRequest) {
        Intrinsics.checkParameterIsNotNull((Object)eventRequest, (String)"eventRequest");
        if (StringsKt.contains((CharSequence)eventRequest.getTopic(), (CharSequence)"response", (boolean)true) || StringsKt.contains((CharSequence)eventRequest.getTopic(), (CharSequence)"advice", (boolean)true)) {
            this.getLog().info("MqttService - Event Received " + eventRequest.getTopic() + ' ' + eventRequest.getPayload());
            this.publish(eventRequest.getTopic(), eventRequest.getPayload());
        }
    }

    @NotNull
    public EventDispatcherServiceImpl getEventDispatcherService() {
        return this.eventDispatcherService;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public String getServerUri() {
        return this.serverUri;
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    @NotNull
    public String getPassword() {
        return this.password;
    }

    public boolean getRetainMessage() {
        return this.retainMessage;
    }

    @NotNull
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.instanceId = string;
    }

    @NotNull
    public String getTopicBase() {
        return this.topicBase;
    }

    public void setTopicBase(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.topicBase = string;
    }

    public MqttServiceImpl(@Autowired @NotNull EventDispatcherServiceImpl eventDispatcherService, @Value(value="${grit.mqtt.enabled:false}") boolean enabled, @Value(value="${grit.mqtt.url:tcp:://localhost:1883}") @NotNull String serverUri, @Value(value="${grit.mqtt.username:@null}") @NotNull String username, @Value(value="${grit.mqtt.password:@null}") @NotNull String password, @Value(value="${grit.mqtt.retain:true}") boolean retainMessage, @Value(value="${grit.instanceId}") @NotNull String instanceId, @Value(value="${grit.mqtt.topic.base:grit}") @NotNull String topicBase) {
        Intrinsics.checkParameterIsNotNull((Object)eventDispatcherService, (String)"eventDispatcherService");
        Intrinsics.checkParameterIsNotNull((Object)serverUri, (String)"serverUri");
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull((Object)instanceId, (String)"instanceId");
        Intrinsics.checkParameterIsNotNull((Object)topicBase, (String)"topicBase");
        this.eventDispatcherService = eventDispatcherService;
        this.enabled = enabled;
        this.serverUri = serverUri;
        this.username = username;
        this.password = password;
        this.retainMessage = retainMessage;
        this.instanceId = instanceId;
        this.topicBase = topicBase;
        this.running = true;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(this.javaClass)");
        this.log = logger;
    }

    public static final /* synthetic */ FutureConnection access$getConnection$p(MqttServiceImpl $this) {
        FutureConnection futureConnection = $this.connection;
        if (futureConnection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
        }
        return futureConnection;
    }

    public static final /* synthetic */ void access$setConnection$p(MqttServiceImpl $this, FutureConnection futureConnection) {
        $this.connection = futureConnection;
    }

    public static final /* synthetic */ boolean access$getRunning$p(MqttServiceImpl $this) {
        return $this.running;
    }

    public static final /* synthetic */ void access$setRunning$p(MqttServiceImpl $this, boolean bl) {
        $this.running = bl;
    }
}

