/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.service;

import com.google.common.eventbus.EventBus;
import io.gritlabs.probe.domain.service.AdminService;
import io.gritlabs.probe.domain.service.DeviceService;
import io.gritlabs.probe.domain.service.EventDispatcherService;
import io.gritlabs.probe.domain.service.EventDispatcherServiceImpl;
import io.gritlabs.probe.domain.service.model.DeviceModel;
import io.gritlabs.probe.domain.service.model.EventListener;
import io.gritlabs.probe.domain.service.model.EventRequestModel;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0019\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00190\u0018H\u0017J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0092.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lio/gritlabs/probe/domain/service/EventDispatcherServiceImpl;", "Lio/gritlabs/probe/domain/service/EventDispatcherService;", "Lorg/springframework/context/ApplicationContextAware;", "adminService", "Lio/gritlabs/probe/domain/service/AdminService;", "deviceService", "Lio/gritlabs/probe/domain/service/DeviceService;", "(Lio/gritlabs/probe/domain/service/AdminService;Lio/gritlabs/probe/domain/service/DeviceService;)V", "getAdminService", "()Lio/gritlabs/probe/domain/service/AdminService;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "getDeviceService", "()Lio/gritlabs/probe/domain/service/DeviceService;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "dispatch", "", "topic", "", "payload", "registerDeviceListeners", "", "Lio/gritlabs/probe/domain/service/model/EventListener;", "setApplicationContext", "Companion", "grit-probe"})
public class EventDispatcherServiceImpl
implements EventDispatcherService,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    @NotNull
    private final Logger log;
    @NotNull
    private final AdminService adminService;
    @NotNull
    private final DeviceService deviceService;
    @NotNull
    private static final EventBus eventBus;
    public static final Companion Companion;

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
    }

    @NotNull
    public Logger getLog() {
        return this.log;
    }

    public void dispatch(@Nullable String topic, @NotNull String payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        String string = topic;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if (StringsKt.endsWith$default((String)string, (String)"request", (boolean)false, (int)2, null)) {
            this.getLog().debug("Received Dispatch Event " + this.getAdminService().getInstanceId() + ' ' + topic + ' ' + payload);
            if (StringsKt.contains$default((CharSequence)topic, (CharSequence)this.getAdminService().getInstanceId(), (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)topic, (CharSequence)"broadcast", (boolean)false, (int)2, null)) {
                this.getLog().debug("Dispatch Event [" + topic + "] [" + payload + ']');
                EventRequestModel event = new EventRequestModel(topic, payload);
                eventBus.post((Object)event);
            }
        } else {
            this.getLog().trace("Dispatch received event that is not a request.");
        }
    }

    @PostConstruct
    @NotNull
    public Map<String, EventListener> registerDeviceListeners() {
        try {
            List list = this.getDeviceService().getEnabledDevices();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DeviceModel it = (DeviceModel)element$iv;
                    boolean bl = false;
                    if (!(it.getDriver() instanceof EventListener)) continue;
                    this.getLog().info("Event Listener Registered : " + it.getName());
                    eventBus.register((Object)it.getDriver());
                }
            }
        }
        catch (Exception e) {
            this.getLog().warn("Listeners Exception", (Throwable)e);
        }
        boolean bl = false;
        return new LinkedHashMap();
    }

    @NotNull
    public AdminService getAdminService() {
        return this.adminService;
    }

    @NotNull
    public DeviceService getDeviceService() {
        return this.deviceService;
    }

    public EventDispatcherServiceImpl(@Autowired @NotNull AdminService adminService, @Autowired @NotNull DeviceService deviceService) {
        Intrinsics.checkParameterIsNotNull((Object)adminService, (String)"adminService");
        Intrinsics.checkParameterIsNotNull((Object)deviceService, (String)"deviceService");
        this.adminService = adminService;
        this.deviceService = deviceService;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(this.javaClass)");
        this.log = logger;
    }

    static {
        Companion = new Companion(null);
        eventBus = new EventBus();
    }

    public static final /* synthetic */ EventBus access$getEventBus$cp() {
        return eventBus;
    }
}

