/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.service;

import com.google.common.eventbus.EventBus;
import io.gritlabs.probe.domain.service.AdminService;
import io.gritlabs.probe.domain.service.EventDispatcherServiceImpl;
import io.gritlabs.probe.domain.service.model.EventListener;
import io.gritlabs.probe.domain.service.model.EventRequestModel;
import io.gritlabs.probe.domain.service.model.EventResponseModel;
import io.gritlabs.probe.domain.service.model.HeartbeatModel;
import io.gritlabs.probe.util.Util;
import io.gritlabs.probe.util.VersionHolder;
import java.time.ZonedDateTime;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0001\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0012J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\b\u0010\u0016\u001a\u00020\u0010H\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0017R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000b\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/gritlabs/probe/domain/service/AdminServiceImpl;", "Lio/gritlabs/probe/domain/service/AdminService;", "Lio/gritlabs/probe/domain/service/model/EventListener;", "license", "", "versionHolder", "Lio/gritlabs/probe/util/VersionHolder;", "instanceId", "topicBase", "(Ljava/lang/String;Lio/gritlabs/probe/util/VersionHolder;Ljava/lang/String;Ljava/lang/String;)V", "getInstanceId", "()Ljava/lang/String;", "getTopicBase", "setTopicBase", "(Ljava/lang/String;)V", "checkLicense", "", "eventRequest", "Lio/gritlabs/probe/domain/service/model/EventRequestModel;", "getHeartbeat", "Lio/gritlabs/probe/domain/service/model/HeartbeatModel;", "heartbeat", "init", "isCommand", "", "isHeartbeat", "isLicenseCheck", "onEventReceived", "sendVersionInfo", "grit-probe"})
public class AdminServiceImpl
implements AdminService,
EventListener {
    private final String license;
    private final VersionHolder versionHolder;
    @NotNull
    private final String instanceId;
    @NotNull
    private String topicBase;

    @PostConstruct
    public void init() {
    }

    @Scheduled(initialDelay=30000L, fixedDelay=60000L)
    public void sendVersionInfo() {
        EventDispatcherServiceImpl.Companion.getEventBus().post((Object)new EventRequestModel(this.getTopicBase() + '/' + this.getInstanceId() + "/admin/version/advice", this.versionHolder.getVersion()));
    }

    public void onEventReceived(@NotNull EventRequestModel eventRequest) {
        Intrinsics.checkParameterIsNotNull((Object)eventRequest, (String)"eventRequest");
        if (StringsKt.contains$default((CharSequence)eventRequest.getTopic(), (CharSequence)(this.getTopicBase() + '/' + this.getInstanceId() + '/'), (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)eventRequest.getTopic(), (CharSequence)(this.getTopicBase() + "/broadcast/"), (boolean)false, (int)2, null)) {
            if (this.isLicenseCheck(eventRequest)) {
                this.checkLicense(eventRequest);
                return;
            }
            if (this.isHeartbeat(eventRequest)) {
                this.heartbeat(eventRequest);
                return;
            }
            EventDispatcherServiceImpl.Companion.getEventBus().post((Object)new EventResponseModel(eventRequest.getTopic() + "/response", "Unsupported"));
        }
    }

    private void heartbeat(EventRequestModel eventRequest) {
        EventBus eventBus = EventDispatcherServiceImpl.Companion.getEventBus();
        String string = eventRequest.getTopic() + "/heartbeat/response";
        String string2 = ZonedDateTime.now().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ZonedDateTime.now().toString()");
        eventBus.post((Object)new EventResponseModel(string, string2));
    }

    private void checkLicense(EventRequestModel eventRequest) {
        EventDispatcherServiceImpl.Companion.getEventBus().post((Object)new EventResponseModel(eventRequest.getTopic() + "/license/response", this.license));
    }

    private boolean isCommand(EventRequestModel eventRequest) {
        return StringsKt.contains$default((CharSequence)eventRequest.getTopic(), (CharSequence)"admin/command/request", (boolean)false, (int)2, null);
    }

    private boolean isLicenseCheck(EventRequestModel eventRequest) {
        return StringsKt.contains$default((CharSequence)eventRequest.getTopic(), (CharSequence)"admin/licenseCheck/request", (boolean)false, (int)2, null);
    }

    private boolean isHeartbeat(EventRequestModel eventRequest) {
        return StringsKt.contains$default((CharSequence)eventRequest.getTopic(), (CharSequence)"admin/heartbeat/request", (boolean)false, (int)2, null);
    }

    private HeartbeatModel getHeartbeat() {
        HeartbeatModel heartbeat = new HeartbeatModel();
        heartbeat.setHostname(Util.Companion.getHostname().toString());
        heartbeat.setVersion(this.versionHolder.getVersion());
        heartbeat.setInstanceId(this.getInstanceId());
        return heartbeat;
    }

    @NotNull
    public String getInstanceId() {
        return this.instanceId;
    }

    @NotNull
    public String getTopicBase() {
        return this.topicBase;
    }

    public void setTopicBase(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.topicBase = string;
    }

    public AdminServiceImpl(@Value(value="${grit.admin.license:INVALID}") @NotNull String license, @Autowired @NotNull VersionHolder versionHolder, @Value(value="${grit.instanceId:INVALID}") @NotNull String instanceId, @Value(value="${grit.mqtt.topic.base:grit}") @NotNull String topicBase) {
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        Intrinsics.checkParameterIsNotNull((Object)versionHolder, (String)"versionHolder");
        Intrinsics.checkParameterIsNotNull((Object)instanceId, (String)"instanceId");
        Intrinsics.checkParameterIsNotNull((Object)topicBase, (String)"topicBase");
        this.license = license;
        this.versionHolder = versionHolder;
        this.instanceId = instanceId;
        this.topicBase = topicBase;
    }
}

