/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.driver.voltronic.protocol;

import io.gritlabs.probe.domain.driver.voltronic.VoltronicParseException;
import io.gritlabs.probe.domain.driver.voltronic.protocol.VoltronicCommandResponse;
import io.gritlabs.probe.domain.driver.voltronic.protocol.VoltronicQpigs;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lio/gritlabs/probe/domain/driver/voltronic/protocol/QpigsCommandResponse;", "Lio/gritlabs/probe/domain/driver/voltronic/protocol/VoltronicCommandResponse;", "response", "", "([B)V", "data", "Lio/gritlabs/probe/domain/driver/voltronic/protocol/VoltronicQpigs;", "getData", "()Lio/gritlabs/probe/domain/driver/voltronic/protocol/VoltronicQpigs;", "setData", "(Lio/gritlabs/probe/domain/driver/voltronic/protocol/VoltronicQpigs;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "toString", "", "grit-probe"})
public final class QpigsCommandResponse
extends VoltronicCommandResponse {
    @Nullable
    private VoltronicQpigs data;
    @NotNull
    private final Logger log;

    @Nullable
    public final VoltronicQpigs getData() {
        return this.data;
    }

    public final void setData(@Nullable VoltronicQpigs voltronicQpigs) {
        this.data = voltronicQpigs;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public String toString() {
        return "QpigsCommandResponse(data=" + this.data + ')';
    }

    public QpigsCommandResponse(@NotNull byte[] response) {
        String deviceStatus2;
        String deviceStatus1;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        super(response);
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(this.javaClass)");
        this.log = logger;
        byte[] byArray = response;
        boolean bl = false;
        if (byArray.length == 0) {
            return;
        }
        byte[] byArray2 = response;
        int n = 1;
        int n2 = response.length;
        boolean bl2 = false;
        byte[] buffer = ArraysKt.copyOfRange((byte[])byArray2, (int)n, (int)n2);
        if (buffer.length < 106) {
            StringBuilder stringBuilder = new StringBuilder().append("QpigsCommandResponse - Invalid Data Length [").append(response.length).append("] expecting 106, raw: [");
            boolean bl3 = false;
            String string = new String(response, Charsets.UTF_8);
            String string2 = stringBuilder.append(string).append(']').toString();
            throw (Throwable)new VoltronicParseException(string2);
        }
        n = 0;
        List data = StringsKt.split$default((CharSequence)new String(buffer, Charsets.UTF_8), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
        this.log.trace("QpigsCommandResponse: raw=[" + data + ']');
        String string = (String)data.get(0);
        boolean bl4 = false;
        double gridVoltage = Double.parseDouble(string);
        String string3 = (String)data.get(1);
        boolean bl5 = false;
        double gridFrequency = Double.parseDouble(string3);
        String string4 = (String)data.get(2);
        boolean bl6 = false;
        double loadVoltage = Double.parseDouble(string4);
        String string5 = (String)data.get(3);
        boolean bl7 = false;
        double loadFrequency = Double.parseDouble(string5);
        String string6 = (String)data.get(4);
        boolean bl8 = false;
        double loadApparentPower = Double.parseDouble(string6);
        String string7 = (String)data.get(5);
        boolean bl9 = false;
        double loadPower = Double.parseDouble(string7);
        String string8 = (String)data.get(6);
        boolean bl10 = false;
        double loadPercent = Double.parseDouble(string8);
        String string9 = (String)data.get(7);
        boolean bl11 = false;
        double busDcVoltage = Double.parseDouble(string9);
        String string10 = (String)data.get(8);
        boolean bl12 = false;
        double batteryVoltage = Double.parseDouble(string10);
        String string11 = (String)data.get(9);
        boolean bl13 = false;
        double batteryChargeCurrent = Double.parseDouble(string11);
        String string12 = (String)data.get(10);
        boolean bl14 = false;
        double batteryCapacity = Double.parseDouble(string12);
        String string13 = (String)data.get(11);
        boolean bl15 = false;
        double heatsinkTemperature = Double.parseDouble(string13);
        String string14 = (String)data.get(12);
        boolean bl16 = false;
        double mpptCurrent = Double.parseDouble(string14);
        String string15 = (String)data.get(13);
        boolean bl17 = false;
        double mpptVoltage = Double.parseDouble(string15);
        String string16 = (String)data.get(15);
        boolean bl18 = false;
        double batteryDischargeCurrent = Double.parseDouble(string16);
        double batteryCurrent = batteryChargeCurrent + batteryDischargeCurrent;
        double batteryPower = batteryDischargeCurrent > 0.0 ? (double)-1 * batteryDischargeCurrent * batteryVoltage : batteryChargeCurrent * batteryVoltage;
        String string17 = deviceStatus1 = (String)data.get(16);
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        String string18 = string17;
        if (string18 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string19 = string18.substring(n3, n4);
        Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String sbuPriorityVersion = string19;
        String string20 = deviceStatus1;
        n4 = 1;
        n5 = 2;
        int n6 = 0;
        String string21 = string20;
        if (string21 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string22 = string21.substring(n4, n5);
        Intrinsics.checkExpressionValueIsNotNull((Object)string22, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String configurationUpdated = string22;
        String string23 = deviceStatus1;
        n5 = 2;
        n6 = 3;
        int n7 = 0;
        String string24 = string23;
        if (string24 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string25 = string24.substring(n5, n6);
        Intrinsics.checkExpressionValueIsNotNull((Object)string25, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String sccFirmwareUpdated = string25;
        String string26 = deviceStatus1;
        n6 = 3;
        n7 = 4;
        int n8 = 0;
        String string27 = string26;
        if (string27 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string28 = string27.substring(n6, n7);
        Intrinsics.checkExpressionValueIsNotNull((Object)string28, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String loadStatus = string28;
        String string29 = deviceStatus1;
        n7 = 4;
        n8 = 5;
        int n9 = 0;
        String string30 = string29;
        if (string30 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string31 = string30.substring(n7, n8);
        Intrinsics.checkExpressionValueIsNotNull((Object)string31, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String batteryVoltageSteadyUnderCharge = string31;
        String string32 = deviceStatus1;
        n8 = 5;
        n9 = 7;
        boolean bl19 = false;
        String string33 = string32;
        if (string33 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string34 = string33.substring(n8, n9);
        Intrinsics.checkExpressionValueIsNotNull((Object)string34, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String deviceChargingStatus = string34;
        String chargingStatusScc1 = "0";
        if (Intrinsics.areEqual((Object)deviceChargingStatus, (Object)"110")) {
            chargingStatusScc1 = "1";
        }
        String acChargeEnabled = "0";
        if (Intrinsics.areEqual((Object)deviceChargingStatus, (Object)"101")) {
            acChargeEnabled = "1";
        }
        if (Intrinsics.areEqual((Object)deviceChargingStatus, (Object)"111")) {
            acChargeEnabled = "1";
            chargingStatusScc1 = "1";
        }
        String batteryVoltageOffset = (String)data.get(17);
        String eepromVersion = (String)data.get(18);
        String string35 = (String)data.get(19);
        boolean bl20 = false;
        double mpptPower1 = Double.parseDouble(string35);
        String string36 = deviceStatus2 = (String)data.get(20);
        int n10 = 0;
        int n11 = 1;
        int n12 = 0;
        String string37 = string36;
        if (string37 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string38 = string37.substring(n10, n11);
        Intrinsics.checkExpressionValueIsNotNull((Object)string38, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String chargingFloatMode = string38;
        String string39 = deviceStatus2;
        n11 = 1;
        n12 = 2;
        int n13 = 0;
        String string40 = string39;
        if (string40 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string41 = string40.substring(n11, n12);
        Intrinsics.checkExpressionValueIsNotNull((Object)string41, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String powerSwitchState = string41;
        String string42 = deviceStatus2;
        n12 = 2;
        n13 = 3;
        boolean bl21 = false;
        String string43 = string42;
        if (string43 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string44 = string43.substring(n12, n13);
        Intrinsics.checkExpressionValueIsNotNull((Object)string44, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String reserved1 = string44;
        this.data = new VoltronicQpigs(gridVoltage, gridFrequency, loadVoltage, loadApparentPower, loadPower, loadPercent, busDcVoltage, batteryVoltage, batteryChargeCurrent, batteryCapacity, heatsinkTemperature, mpptCurrent, mpptVoltage, 0.0, batteryDischargeCurrent, deviceStatus1, sbuPriorityVersion, configurationUpdated, sccFirmwareUpdated, loadStatus, batteryVoltageSteadyUnderCharge, chargingStatusScc1, acChargeEnabled, chargingStatusScc1, batteryVoltageOffset, eepromVersion, mpptPower1, deviceStatus2, chargingFloatMode, powerSwitchState, reserved1, loadFrequency, deviceChargingStatus, batteryCurrent, batteryPower);
    }
}

