/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.driver.morningstar;

import com.digitalpetri.modbus.master.ModbusTcpMaster;
import com.digitalpetri.modbus.master.ModbusTcpMasterConfig;
import com.digitalpetri.modbus.requests.ModbusRequest;
import com.digitalpetri.modbus.requests.ReadHoldingRegistersRequest;
import com.digitalpetri.modbus.responses.ReadHoldingRegistersResponse;
import io.gritlabs.probe.domain.driver.PollingDriver;
import io.gritlabs.probe.domain.driver.morningstar.TsMppt60Protocol;
import io.gritlabs.probe.domain.service.dto.MeasurementDto;
import io.gritlabs.probe.domain.service.dto.PointDto;
import io.gritlabs.probe.domain.service.dto.PointTypeDto;
import io.gritlabs.probe.domain.service.model.DeviceModel;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001e\u001a\u00020\u001fH\u0012J\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u001fH\u0012J\b\u0010\"\u001a\u00020\u001fH\u0017J\b\u0010#\u001a\u00020\u001fH\u0016J\b\u0010$\u001a\u00020\u001fH\u0012J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0013H\u0016J\b\u0010'\u001a\u00020\u001fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0092.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lio/gritlabs/probe/domain/driver/morningstar/TsMppt60ModBusDriver;", "Lio/gritlabs/probe/domain/driver/PollingDriver;", "device", "Lio/gritlabs/probe/domain/service/model/DeviceModel;", "(Lio/gritlabs/probe/domain/service/model/DeviceModel;)V", "connected", "", "getDevice", "()Lio/gritlabs/probe/domain/service/model/DeviceModel;", "setDevice", "hostname", "", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "master", "Lcom/digitalpetri/modbus/master/ModbusTcpMaster;", "port", "", "getPort", "()I", "setPort", "(I)V", "updated", "Ljava/time/ZonedDateTime;", "getUpdated", "()Ljava/time/ZonedDateTime;", "setUpdated", "(Ljava/time/ZonedDateTime;)V", "connect", "", "destroy", "disconnect", "init", "process", "queryAllRegisters", "queryRegister", "address", "validate", "grit-probe"})
public class TsMppt60ModBusDriver
extends PollingDriver {
    private String hostname;
    private int port;
    private boolean connected;
    @NotNull
    private ZonedDateTime updated;
    @NotNull
    private final Logger log;
    private ModbusTcpMaster master;
    @NotNull
    private DeviceModel device;

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public ZonedDateTime getUpdated() {
        return this.updated;
    }

    public void setUpdated(@NotNull ZonedDateTime zonedDateTime) {
        Intrinsics.checkParameterIsNotNull((Object)zonedDateTime, (String)"<set-?>");
        this.updated = zonedDateTime;
    }

    @NotNull
    public Logger getLog() {
        return this.log;
    }

    @PostConstruct
    public void init() {
        Object object = this.getDevice().getParameters().get((Object)"hostname");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        this.hostname = (String)object;
        this.setPort(Integer.parseInt(String.valueOf(this.getDevice().getParameters().get((Object)"port"))));
        ModbusTcpMasterConfig config = new ModbusTcpMasterConfig.Builder(this.hostname).setPort(this.getPort()).setAutoConnect(true).setExecutor(Executors.newCachedThreadPool()).setTimeout(Duration.ofMillis(this.getDevice().getTimeout())).setInstanceId(UUID.randomUUID().toString()).build();
        this.master = new ModbusTcpMaster(config);
    }

    public int queryRegister(int address) {
        byte[] addressBuffer = ByteBuffer.allocate(4).putInt(address).array();
        try {
            int n;
            ReadHoldingRegistersResponse response;
            Logger logger = this.getLog();
            StringBuilder stringBuilder = new StringBuilder().append("Request: address=[0x");
            char[] cArray = Hex.encodeHex((byte[])addressBuffer);
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"Hex.encodeHex(addressBuffer)");
            char[] cArray2 = cArray;
            StringBuilder stringBuilder2 = stringBuilder;
            Logger logger2 = logger;
            boolean bl = false;
            String string = new String(cArray2);
            logger2.debug(stringBuilder2.append(string).append(']').toString());
            ModbusTcpMaster modbusTcpMaster = this.master;
            if (modbusTcpMaster == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"master");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(addressBuffer);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(addressBuffer)");
            ReadHoldingRegistersResponse readHoldingRegistersResponse = response = (ReadHoldingRegistersResponse)modbusTcpMaster.sendRequest((ModbusRequest)new ReadHoldingRegistersRequest(byteBuffer.getInt(), 1), 1).join();
            Intrinsics.checkExpressionValueIsNotNull((Object)readHoldingRegistersResponse, (String)"response");
            byte[] responseBuffer = new byte[readHoldingRegistersResponse.getRegisters().readableBytes()];
            response.getRegisters().duplicate().readBytes(responseBuffer);
            int value = 0;
            switch (responseBuffer.length) {
                case 2: {
                    ByteBuffer byteBuffer2 = ByteBuffer.wrap(responseBuffer);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer2, (String)"ByteBuffer.wrap(responseBuffer)");
                    n = byteBuffer2.getShort();
                    break;
                }
                case 4: {
                    ByteBuffer byteBuffer3 = ByteBuffer.wrap(responseBuffer);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer3, (String)"ByteBuffer.wrap(responseBuffer)");
                    n = byteBuffer3.getInt();
                    break;
                }
                default: {
                    this.getLog().warn("Response Buffer Overflow: dataLength=[" + responseBuffer.length + ']');
                    return 0;
                }
            }
            value = n;
            this.getLog().debug("Response: data=[" + value + ']');
            return value;
        }
        catch (ClosedChannelException e) {
            throw (Throwable)e;
        }
        catch (CompletionException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            Logger logger = this.getLog();
            StringBuilder stringBuilder = new StringBuilder().append("Query Register address=[0x");
            char[] cArray = Hex.encodeHex((byte[])addressBuffer);
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"Hex.encodeHex(addressBuffer)");
            char[] cArray3 = cArray;
            StringBuilder stringBuilder3 = stringBuilder;
            Logger logger3 = logger;
            boolean bl = false;
            String string = new String(cArray3);
            logger3.error(stringBuilder3.append(string).append("] ").append("Exception - [").append(e.getMessage()).append(']').toString(), (Throwable)e);
            throw (Throwable)e;
        }
    }

    private void disconnect() {
        ModbusTcpMaster modbusTcpMaster = this.master;
        if (modbusTcpMaster == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"master");
        }
        modbusTcpMaster.disconnect().whenComplete((BiConsumer)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void connect() {
        ModbusTcpMaster modbusTcpMaster = this.master;
        if (modbusTcpMaster == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"master");
        }
        modbusTcpMaster.connect().whenComplete((BiConsumer)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (!this.getDevice().getEnabled()) {
            return;
        }
        System.gc();
        try {
            if (!this.connected) {
                this.connect();
            }
            this.queryAllRegisters();
        }
        catch (CompletionException e) {
            this.getLog().warn("Poll Completion Exception - [" + e.getMessage() + ']');
        }
        catch (Exception e) {
            this.getLog().error("Poll Exception - [" + e.getMessage() + ']', (Throwable)e);
        }
        finally {
            this.disconnect();
        }
    }

    public void validate() {
    }

    public void destroy() {
    }

    private void queryAllRegisters() {
        long start = Instant.now().toEpochMilli();
        boolean bl = false;
        List points = new ArrayList();
        int vPuHi = this.queryRegister(0);
        points.add(new PointDto("V_PU_HI", (Object)vPuHi, PointTypeDto.INT32));
        int vPuLo = this.queryRegister(1);
        points.add(new PointDto("V_PU_LO", (Object)vPuLo, PointTypeDto.INT32));
        double vPu = (double)vPuHi + (double)vPuLo / Math.pow(2.0, 16.0);
        points.add(new PointDto("V_PU", (Object)vPu, PointTypeDto.INT32));
        int iPuHi = this.queryRegister(2);
        points.add(new PointDto("I_PU_HI", (Object)iPuHi, PointTypeDto.INT32));
        int iPuLo = this.queryRegister(3);
        points.add(new PointDto("I_PU_LO", (Object)iPuLo, PointTypeDto.INT32));
        double iPu = (double)iPuHi + (double)iPuLo / Math.pow(2.0, 16.0);
        points.add(new PointDto("I_PU", (Object)iPu, PointTypeDto.INT32));
        if (vPu > 0.0 && iPu > 0.0) {
            int softwareVersion = this.queryRegister(4);
            points.add(new PointDto("softwareVersion", (Object)softwareVersion, PointTypeDto.STRING));
            int adcVbFMed = this.queryRegister(24);
            double batteryVoltageFiltered = (double)adcVbFMed * vPu * Math.pow(2.0, -15.0);
            points.add(new PointDto("batteryVoltageFiltered", (Object)batteryVoltageFiltered, PointTypeDto.DECIMAL));
            int adcVbTermF = this.queryRegister(25);
            double batteryTerminalVoltage = (double)adcVbTermF * vPu * Math.pow(2.0, -15.0);
            points.add(new PointDto("batteryTerminalVoltage", (Object)batteryTerminalVoltage, PointTypeDto.DECIMAL));
            int adcVbsF = this.queryRegister(26);
            double batterySenseVoltage = (double)adcVbsF * vPu * Math.pow(2.0, -15.0);
            points.add(new PointDto("batterySenseVoltage", (Object)batterySenseVoltage, PointTypeDto.DECIMAL));
            int adcVaF = this.queryRegister(27);
            double arrayVoltageFiltered = (double)adcVaF * vPu * Math.pow(2.0, -15.0);
            points.add(new PointDto("arrayVoltageFiltered", (Object)arrayVoltageFiltered, PointTypeDto.DECIMAL));
            int adcIbFShadow = this.queryRegister(28);
            double batteryCurrentFiltered = (double)adcIbFShadow * iPu * Math.pow(2.0, -15.0);
            points.add(new PointDto("batteryCurrentFiltered", (Object)batteryCurrentFiltered, PointTypeDto.DECIMAL));
            int adcIaFShadow = this.queryRegister(29);
            double arrayCurrentFiltered = (double)adcIaFShadow * iPu * Math.pow(2.0, -15.0);
            points.add(new PointDto("arrayCurrentFiltered", (Object)arrayCurrentFiltered, PointTypeDto.DECIMAL));
            int adcP12 = this.queryRegister(30);
            double powerSupply12v = (double)adcP12 * 18.612 * Math.pow(2.0, -15.0);
            points.add(new PointDto("powerSupply12Volt", (Object)powerSupply12v, PointTypeDto.DECIMAL));
            int adcP3 = this.queryRegister(31);
            double powerSupply3v = (double)adcP3 * 6.6 * Math.pow(2.0, -15.0);
            points.add(new PointDto("powerSupply3Volt", (Object)powerSupply3v, PointTypeDto.DECIMAL));
            int adcPMeterF = this.queryRegister(32);
            double meterbusVoltageFiltered = (double)adcPMeterF * 18.612 * Math.pow(2.0, -15.0);
            points.add(new PointDto("meterbusVoltageFiltered", (Object)meterbusVoltageFiltered, PointTypeDto.DECIMAL));
            int adcP18F = this.queryRegister(33);
            double powerSupply1_8v = (double)adcP18F * 3.2 * Math.pow(2.0, -15.0);
            points.add(new PointDto("powerSupply1.8Volt", (Object)powerSupply1_8v, PointTypeDto.DECIMAL));
            int adcVRef = this.queryRegister(34);
            double referenceVoltage = (double)adcVRef * 3.2 * Math.pow(2.0, -15.0);
            points.add(new PointDto("referenceVoltage", (Object)referenceVoltage, PointTypeDto.DECIMAL));
            int tHs = this.queryRegister(35);
            points.add(new PointDto("heatsinkTemperatureCelsius", (Object)tHs, PointTypeDto.INT32));
            int tRts = this.queryRegister(36);
            points.add(new PointDto("rtsTemperatureCelsius", (Object)tRts, PointTypeDto.INT32));
            int tBatt = this.queryRegister(37);
            points.add(new PointDto("batteryTemperatureCelsius", (Object)tBatt, PointTypeDto.INT32));
            int adcVbF1m = this.queryRegister(38);
            double batteryVoltage1Min = (double)adcVbF1m * vPu * Math.pow(2.0, -15.0);
            points.add(new PointDto("batteryVoltage1Min", (Object)batteryVoltage1Min, PointTypeDto.DECIMAL));
            int adcIbF1m = this.queryRegister(39);
            double chargingCurrent1Min = (double)adcIbF1m * iPu * Math.pow(2.0, -15.0);
            points.add(new PointDto("chargingCurrent1Min", (Object)chargingCurrent1Min, PointTypeDto.DECIMAL));
            int ledState = this.queryRegister(49);
            points.add(new PointDto("ledState", (Object)ledState, PointTypeDto.STRING));
            points.add(new PointDto("ledStateDisplay", (Object)TsMppt60Protocol.Companion.parseLedStateDisplay(String.valueOf(ledState)), PointTypeDto.STRING));
            int chargeState = this.queryRegister(50);
            points.add(new PointDto("chargeState", (Object)chargeState, PointTypeDto.STRING));
            points.add(new PointDto("chargeStateDisplay", (Object)TsMppt60Protocol.Companion.parseChargingStateDisplay(String.valueOf(chargeState)), PointTypeDto.STRING));
            int powerOutShadow = this.queryRegister(58);
            double mpptOutputPower = (double)powerOutShadow * vPu * iPu * Math.pow(2.0, -17.0);
            points.add(new PointDto("mpptOutputPower", (Object)mpptOutputPower, PointTypeDto.DECIMAL));
            int powerInShadow = this.queryRegister(59);
            double mpptInputPower = (double)powerInShadow * vPu * iPu * Math.pow(2.0, -17.0);
            points.add(new PointDto("mpptInputPower", (Object)mpptInputPower, PointTypeDto.DECIMAL));
            int sweepPinMax = this.queryRegister(60);
            double mpptMaxPowerSweep = (double)sweepPinMax * vPu * iPu * Math.pow(2.0, -17.0);
            points.add(new PointDto("mpptMaxPowerSweep", (Object)mpptMaxPowerSweep, PointTypeDto.DECIMAL));
            int sweepVmp = this.queryRegister(61);
            double mpptVmpSweep = (double)sweepVmp * vPu * Math.pow(2.0, -15.0);
            points.add(new PointDto("mpptVmpSweep", (Object)mpptVmpSweep, PointTypeDto.DECIMAL));
            int sweepVoc = this.queryRegister(62);
            double mpptVocSweep = (double)sweepVoc * vPu * Math.pow(2.0, -15.0);
            points.add(new PointDto("mpptVocSweep", (Object)mpptVocSweep, PointTypeDto.DECIMAL));
        }
        this.getTelemetry().setMeasurement(new MeasurementDto(Instant.now().toEpochMilli() - start, Instant.now().toEpochMilli(), points));
    }

    @NotNull
    public DeviceModel getDevice() {
        return this.device;
    }

    public void setDevice(@NotNull DeviceModel deviceModel) {
        Intrinsics.checkParameterIsNotNull((Object)deviceModel, (String)"<set-?>");
        this.device = deviceModel;
    }

    public TsMppt60ModBusDriver(@NotNull DeviceModel device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        super(device, null, 2, null);
        this.device = device;
        this.hostname = "localhost";
        this.port = 502;
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.now()");
        this.updated = zonedDateTime;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(this.javaClass)");
        this.log = logger;
    }

    public static final /* synthetic */ boolean access$getConnected$p(TsMppt60ModBusDriver $this) {
        return $this.connected;
    }

    public static final /* synthetic */ void access$setConnected$p(TsMppt60ModBusDriver $this, boolean bl) {
        $this.connected = bl;
    }
}

