/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.util;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CancelableReader
extends BufferedReader {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private Future future;

    public CancelableReader(Reader reader) {
        super(reader);
    }

    public void cancelRead() {
        this.future.cancel(true);
    }

    @Override
    public String readLine() {
        this.future = this.executor.submit(() -> super.readLine());
        try {
            return (String)this.future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        catch (CancellationException e) {
            return null;
        }
        return null;
    }
}

