/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.modbus.rtu.master;

import com.digitalpetri.modbus.ModbusPdu;
import com.digitalpetri.modbus.codec.ModbusPduDecoder;
import com.digitalpetri.modbus.codec.ModbusPduEncoder;
import com.digitalpetri.modbus.codec.ModbusRequestEncoder;
import com.digitalpetri.modbus.codec.ModbusResponseDecoder;
import com.digitalpetri.modbus.requests.ModbusRequest;
import com.digitalpetri.modbus.requests.WriteMultipleCoilsRequest;
import com.digitalpetri.modbus.requests.WriteMultipleRegistersRequest;
import io.gritlabs.probe.modbus.rtu.codec.ModbusRtuCodec;
import io.gritlabs.probe.modbus.rtu.codec.ModbusRtuPayload;
import io.gritlabs.probe.modbus.rtu.master.ModbusRtuMasterConfig;
import io.gritlabs.probe.modbus.rtu.master.SerialManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.SerialPort;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModbusRtuMaster {
    private final ModbusRtuMasterConfig config;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ModbusRtuCodec modbusRtuCodec;
    private final SerialManager serialManager = new SerialManager();
    private InputStream inputStream;
    private ModbusRtuPayload modbusRtuPayload;
    private OutputStream outputStream;

    public ModbusRtuMaster(ModbusRtuMasterConfig config) {
        this.modbusRtuCodec = new ModbusRtuCodec((ModbusPduEncoder)new ModbusRequestEncoder(), (ModbusPduDecoder)new ModbusResponseDecoder());
        this.config = config;
    }

    public static int calculateCRC(ByteBuf buffer) {
        int crc = 65535;
        int polynomial = 40961;
        for (int i = 0; i < buffer.capacity() - 2; ++i) {
            crc ^= buffer.getByte(i) & 0xFF;
            for (int j = 0; j < 8; ++j) {
                boolean bit16 = (crc & 1) == 1;
                crc >>= 1;
                if (!bit16) continue;
                crc ^= polynomial;
            }
        }
        int b1 = (crc &= 0xFFFF) & 0xFF;
        crc >>= 8;
        return crc |= b1 << 8;
    }

    public byte[] createMsgPayload(byte slaveId, ModbusRequest request) {
        this.modbusRtuPayload = new ModbusRtuPayload(slaveId, (ModbusPdu)request);
        ByteBuf buffer = Unpooled.buffer((int)this.serialManager.getSIZE_INITBUFFER());
        int fcCode = this.modbusRtuPayload.getModbusPdu().getFunctionCode().getCode();
        this.logger.debug("Function Code for the Request : " + fcCode);
        switch (fcCode) {
            case 15: {
                WriteMultipleCoilsRequest writeMultipleCoilsRequest = (WriteMultipleCoilsRequest)this.modbusRtuPayload.getModbusPdu();
                int noOfCoilByte = writeMultipleCoilsRequest.getValues().capacity();
                buffer.capacity(this.serialManager.getSIZE_SLAVEID() + this.serialManager.getSIZE_FUNCODE() + this.serialManager.getSIZE_FIRSTADDRESS() + this.serialManager.getSIZE_DATACOUNT() + this.serialManager.getSIZE_NODATABYTE() + noOfCoilByte + this.serialManager.getSIZE_CRCCODE());
                this.logger.debug("Buffer Capacity : " + buffer.capacity() + " for Function Code : " + fcCode);
                break;
            }
            case 16: {
                WriteMultipleRegistersRequest writeMultipleRegistersRequest = (WriteMultipleRegistersRequest)this.modbusRtuPayload.getModbusPdu();
                int noOfRegisterByte = writeMultipleRegistersRequest.getValues().capacity();
                buffer.capacity(this.serialManager.getSIZE_SLAVEID() + this.serialManager.getSIZE_FUNCODE() + this.serialManager.getSIZE_FIRSTADDRESS() + this.serialManager.getSIZE_DATACOUNT() + this.serialManager.getSIZE_NODATABYTE() + noOfRegisterByte + this.serialManager.getSIZE_CRCCODE());
                this.logger.debug("Buffer Capacity : " + buffer.capacity() + " for Function Code : " + fcCode);
            }
        }
        buffer = this.modbusRtuCodec.encode(this.modbusRtuPayload, buffer);
        int crcCode = ModbusRtuMaster.calculateCRC((ByteBuf)buffer);
        this.logger.debug("Calculated CRC for Payload : " + crcCode);
        this.modbusRtuPayload.setCrcCode(crcCode);
        buffer.writeShort(crcCode);
        return this.serialManager.convertBufferToByteArray(buffer);
    }

    public boolean decodeReceivedBuffer(byte slaveId, ByteBuf buf) {
        try {
            this.modbusRtuCodec.decode(slaveId, buf);
            return true;
        }
        catch (Exception ex) {
            this.logger.error("Error in decoding the Buffer Received");
            return false;
        }
    }

    public ModbusRtuMasterConfig getConfig() {
        return this.config;
    }

    private void printBufferMsg(ByteBuf buffer) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buffer.capacity(); ++i) {
            byte b = buffer.getByte(i);
            sb.append(String.format("%02X ", b));
        }
        System.out.println("HEX String : " + sb.toString().replaceAll("\\s+", ""));
    }

    public ByteBuf readRegisterValuesFromBuffer(ByteBuf buffer) {
        ByteBuf regBuf = Unpooled.buffer((int)(buffer.capacity() - 5));
        for (int i = 3; i < buffer.capacity() - 2; ++i) {
            regBuf.writeByte((int)buffer.getByte(i));
            this.logger.debug("Register Bytes : " + buffer.getByte(i));
        }
        return regBuf;
    }

    public ByteBuf sendRequest(ModbusRequest request, byte slaveId) {
        SerialPort serialPort = this.serialManager.initSerialComm(this.config);
        if (serialPort == null) {
            this.logger.error("Error in initializing serial port.");
            return null;
        }
        byte[] byteMsg = this.createMsgPayload(slaveId, request);
        this.outputStream = this.serialManager.getSerialPortOutputStream(serialPort);
        if (this.outputStream == null) {
            this.logger.error("Error in initializing Output Stream for writing data on Serial Port");
            return null;
        }
        this.serialManager.sendRequestOutStream(this.outputStream, byteMsg);
        this.inputStream = this.serialManager.getSerialPortInputStream(serialPort);
        if (this.inputStream == null) {
            this.logger.error("Error in initializing Input Stream for reading data on Serial Port");
            return null;
        }
        ByteBuf buf = this.serialManager.readResponseOnSerialPort(this.inputStream, this.config);
        if (buf == null) {
            this.logger.error("Error in reading data on Serial Port");
            return null;
        }
        if (!this.decodeReceivedBuffer(slaveId, buf)) {
            this.logger.error("Error in decoding the received buffer.");
            return null;
        }
        buf = this.readRegisterValuesFromBuffer(buf);
        serialPort.close();
        return buf;
    }
}

