/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.driver.voltronic;

import io.gritlabs.probe.domain.driver.PollingDriver;
import io.gritlabs.probe.domain.driver.Status;
import io.gritlabs.probe.domain.driver.voltronic.VoltronicException;
import io.gritlabs.probe.domain.driver.voltronic.VoltronicMksDriver$query$;
import io.gritlabs.probe.domain.driver.voltronic.VoltronicReadException;
import io.gritlabs.probe.domain.driver.voltronic.entity.CoulombEntity;
import io.gritlabs.probe.domain.driver.voltronic.protocol.AnonymousCommandRequest;
import io.gritlabs.probe.domain.driver.voltronic.protocol.AnonymousCommandResponse;
import io.gritlabs.probe.domain.driver.voltronic.protocol.QmodCommandRequest;
import io.gritlabs.probe.domain.driver.voltronic.protocol.QmodCommandResponse;
import io.gritlabs.probe.domain.driver.voltronic.protocol.QpigsCommandRequest;
import io.gritlabs.probe.domain.driver.voltronic.protocol.QpigsCommandResponse;
import io.gritlabs.probe.domain.driver.voltronic.protocol.QpiriCommandRequest;
import io.gritlabs.probe.domain.driver.voltronic.protocol.QpiriCommandResponse;
import io.gritlabs.probe.domain.driver.voltronic.protocol.VoltronicQpigs;
import io.gritlabs.probe.domain.driver.voltronic.protocol.VoltronicQpiri;
import io.gritlabs.probe.domain.driver.voltronic.repository.VoltronicCoulombRepository;
import io.gritlabs.probe.domain.service.dto.MeasurementDto;
import io.gritlabs.probe.domain.service.dto.PointDto;
import io.gritlabs.probe.domain.service.dto.PointTypeDto;
import io.gritlabs.probe.domain.service.model.DeviceModel;
import io.gritlabs.probe.domain.service.model.EventListener;
import io.gritlabs.probe.domain.service.model.EventRequestModel;
import io.gritlabs.probe.util.CancelableReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0012J\u001e\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0012J \u0010/\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0012J\u0010\u00104\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0012J\b\u00105\u001a\u00020+H\u0016J\b\u00106\u001a\u00020+H\u0017J\u0010\u00107\u001a\u00020+2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020+H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0012J\u0010\u0010;\u001a\u0002012\u0006\u0010?\u001a\u00020@H\u0012J\u0010\u0010;\u001a\u00020)2\u0006\u0010A\u001a\u00020BH\u0012J\u0010\u0010;\u001a\u0002032\u0006\u0010C\u001a\u00020DH\u0012J\u0010\u0010;\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0012J\b\u0010H\u001a\u00020+H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0005R\u000e\u0010\u0013\u001a\u00020\u0007X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0007X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001bX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0016\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lio/gritlabs/probe/domain/driver/voltronic/VoltronicMksDriver;", "Lio/gritlabs/probe/domain/driver/PollingDriver;", "Lio/gritlabs/probe/domain/service/model/EventListener;", "device", "Lio/gritlabs/probe/domain/service/model/DeviceModel;", "(Lio/gritlabs/probe/domain/service/model/DeviceModel;)V", "batteryBankDod", "", "batteryBankName", "", "batteryCapacityAh", "batteryLossMultiplier", "coulombRepository", "Lio/gritlabs/probe/domain/driver/voltronic/repository/VoltronicCoulombRepository;", "cumulativeMutex", "", "getDevice", "()Lio/gritlabs/probe/domain/service/model/DeviceModel;", "setDevice", "inverterBaseLoad", "loadLossMultiplier", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "mpptLossMultiplier", "newGridPowerAlgorithm", "", "port", "reading", "updated", "Ljava/time/ZonedDateTime;", "getUpdated", "()Ljava/time/ZonedDateTime;", "setUpdated", "(Ljava/time/ZonedDateTime;)V", "workerExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "calculateBatteryPowerReal", "qpigsResponse", "Lio/gritlabs/probe/domain/driver/voltronic/protocol/QpigsCommandResponse;", "calculateCumulative", "", "points", "", "Lio/gritlabs/probe/domain/service/dto/PointDto;", "calculateGridPower", "qmodResponse", "Lio/gritlabs/probe/domain/driver/voltronic/protocol/QmodCommandResponse;", "qpiriResponse", "Lio/gritlabs/probe/domain/driver/voltronic/protocol/QpiriCommandResponse;", "calculateLoadPowerReal", "destroy", "init", "onEventReceived", "eventRequest", "Lio/gritlabs/probe/domain/service/model/EventRequestModel;", "process", "query", "Lio/gritlabs/probe/domain/driver/voltronic/protocol/AnonymousCommandResponse;", "anonymousCommandRequest", "Lio/gritlabs/probe/domain/driver/voltronic/protocol/AnonymousCommandRequest;", "qmodCommandRequest", "Lio/gritlabs/probe/domain/driver/voltronic/protocol/QmodCommandRequest;", "command", "Lio/gritlabs/probe/domain/driver/voltronic/protocol/QpigsCommandRequest;", "qpiriCommandRequest", "Lio/gritlabs/probe/domain/driver/voltronic/protocol/QpiriCommandRequest;", "", "commandBuffer", "Ljava/nio/ByteBuffer;", "validate", "grit-probe"})
public class VoltronicMksDriver
extends PollingDriver
implements EventListener {
    private final Object cumulativeMutex;
    @Autowired
    private VoltronicCoulombRepository coulombRepository;
    private double batteryLossMultiplier;
    private double loadLossMultiplier;
    private double mpptLossMultiplier;
    private boolean newGridPowerAlgorithm;
    private boolean reading;
    private String port;
    private double inverterBaseLoad;
    private double batteryCapacityAh;
    private String batteryBankName;
    private double batteryBankDod;
    @NotNull
    private ZonedDateTime updated;
    private final ExecutorService workerExecutor;
    @NotNull
    private final Logger log;
    @NotNull
    private DeviceModel device;

    @NotNull
    public ZonedDateTime getUpdated() {
        return this.updated;
    }

    public void setUpdated(@NotNull ZonedDateTime zonedDateTime) {
        Intrinsics.checkParameterIsNotNull((Object)zonedDateTime, (String)"<set-?>");
        this.updated = zonedDateTime;
    }

    @PostConstruct
    public void init() {
        if (!this.getDevice().getEnabled()) {
            this.setStatus(Status.DISABLED.toString());
            return;
        }
        this.port = String.valueOf(this.getDevice().getParameters().get((Object)"port"));
        if (this.getDevice().getParameters().containsKey((Object)"batteryCapacityAh")) {
            double d;
            boolean bl;
            VoltronicMksDriver voltronicMksDriver;
            Object object;
            if (this.getDevice().getParameters().containsKey((Object)"batteryCapacityAh")) {
                Double d2;
                VoltronicMksDriver voltronicMksDriver2 = this;
                Object object2 = this.getDevice().getParameters().get((Object)"batteryCapacityAh");
                if (object2 != null && (object2 = object2.toString()) != null) {
                    object = object2;
                    voltronicMksDriver = voltronicMksDriver2;
                    bl = false;
                    d = Double.parseDouble((String)object);
                    voltronicMksDriver2 = voltronicMksDriver;
                    d2 = d;
                } else {
                    d2 = null;
                }
                if (d2 == null) {
                    Intrinsics.throwNpe();
                }
                voltronicMksDriver2.batteryCapacityAh = d2;
            }
            if (this.getDevice().getParameters().containsKey((Object)"baseLoad")) {
                Double d3;
                VoltronicMksDriver voltronicMksDriver3 = this;
                Object object3 = this.getDevice().getParameters().get((Object)"baseLoad");
                if (object3 != null && (object3 = object3.toString()) != null) {
                    object = object3;
                    voltronicMksDriver = voltronicMksDriver3;
                    bl = false;
                    d = Double.parseDouble((String)object);
                    voltronicMksDriver3 = voltronicMksDriver;
                    d3 = d;
                } else {
                    d3 = null;
                }
                if (d3 == null) {
                    Intrinsics.throwNpe();
                }
                voltronicMksDriver3.inverterBaseLoad = d3;
            }
            if (this.getDevice().getParameters().containsKey((Object)"batteryBankName")) {
                Object object4 = this.getDevice().getParameters().get((Object)"batteryBankName");
                String string = object4 != null ? object4.toString() : null;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                this.batteryBankName = string;
            }
            if (this.getDevice().getParameters().containsKey((Object)"batteryBankDod")) {
                Double d4;
                VoltronicMksDriver voltronicMksDriver4 = this;
                Object object5 = this.getDevice().getParameters().get((Object)"batteryBankDod");
                if (object5 != null && (object5 = object5.toString()) != null) {
                    object = object5;
                    voltronicMksDriver = voltronicMksDriver4;
                    bl = false;
                    d = Double.parseDouble((String)object);
                    voltronicMksDriver4 = voltronicMksDriver;
                    d4 = d;
                } else {
                    d4 = null;
                }
                if (d4 == null) {
                    Intrinsics.throwNpe();
                }
                voltronicMksDriver4.batteryBankDod = d4;
            }
            if (this.getDevice().getParameters().containsKey((Object)"newGridPowerAlgorithm")) {
                Boolean bl2;
                VoltronicMksDriver voltronicMksDriver5 = this;
                Object object6 = this.getDevice().getParameters().get((Object)"newGridPowerAlgorithm");
                if (object6 != null && (object6 = object6.toString()) != null) {
                    object = object6;
                    voltronicMksDriver = voltronicMksDriver5;
                    bl = false;
                    boolean bl3 = Boolean.parseBoolean((String)object);
                    voltronicMksDriver5 = voltronicMksDriver;
                    bl2 = bl3;
                } else {
                    bl2 = null;
                }
                if (bl2 == null) {
                    Intrinsics.throwNpe();
                }
                voltronicMksDriver5.newGridPowerAlgorithm = bl2;
            }
            if (this.getDevice().getParameters().containsKey((Object)"batteryLossMultiplier")) {
                Double d5;
                VoltronicMksDriver voltronicMksDriver6 = this;
                Object object7 = this.getDevice().getParameters().get((Object)"batteryLossMultiplier");
                if (object7 != null && (object7 = object7.toString()) != null) {
                    object = object7;
                    voltronicMksDriver = voltronicMksDriver6;
                    bl = false;
                    double d6 = Double.parseDouble((String)object);
                    voltronicMksDriver6 = voltronicMksDriver;
                    d5 = d6;
                } else {
                    d5 = null;
                }
                if (d5 == null) {
                    Intrinsics.throwNpe();
                }
                voltronicMksDriver6.batteryLossMultiplier = d5;
            }
            if (this.getDevice().getParameters().containsKey((Object)"loadLossMultiplier")) {
                Double d7;
                VoltronicMksDriver voltronicMksDriver7 = this;
                Object object8 = this.getDevice().getParameters().get((Object)"loadLossMultiplier");
                if (object8 != null && (object8 = object8.toString()) != null) {
                    object = object8;
                    voltronicMksDriver = voltronicMksDriver7;
                    bl = false;
                    double d8 = Double.parseDouble((String)object);
                    voltronicMksDriver7 = voltronicMksDriver;
                    d7 = d8;
                } else {
                    d7 = null;
                }
                if (d7 == null) {
                    Intrinsics.throwNpe();
                }
                voltronicMksDriver7.loadLossMultiplier = d7;
            }
            if (this.getDevice().getParameters().containsKey((Object)"mpptLossMultiplier")) {
                Double d9;
                VoltronicMksDriver voltronicMksDriver8 = this;
                Object object9 = this.getDevice().getParameters().get((Object)"mpptLossMultiplier");
                if (object9 != null && (object9 = object9.toString()) != null) {
                    object = object9;
                    voltronicMksDriver = voltronicMksDriver8;
                    bl = false;
                    double d10 = Double.parseDouble((String)object);
                    voltronicMksDriver8 = voltronicMksDriver;
                    d9 = d10;
                } else {
                    d9 = null;
                }
                if (d9 == null) {
                    Intrinsics.throwNpe();
                }
                voltronicMksDriver8.mpptLossMultiplier = d9;
            }
        }
    }

    public void process() {
        if (!this.getDevice().getEnabled()) {
            return;
        }
        long start = Instant.now().toEpochMilli();
        boolean bl = false;
        List points = new ArrayList();
        QmodCommandResponse qmodResponse = this.query(new QmodCommandRequest());
        points.add(new PointDto("InverterMode", (Object)qmodResponse.getMode(), PointTypeDto.STRING));
        QpigsCommandResponse qpigsResponse = this.query(new QpigsCommandRequest());
        double loadPowerReal = this.calculateLoadPowerReal(qpigsResponse);
        double batteryPowerReal = this.calculateBatteryPowerReal(qpigsResponse);
        VoltronicQpigs voltronicQpigs = qpigsResponse.getData();
        if (voltronicQpigs == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("GridVolts", (Object)voltronicQpigs.getGridVoltage(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs2 = qpigsResponse.getData();
        if (voltronicQpigs2 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("GridFrequency", (Object)voltronicQpigs2.getGridFrequency(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs3 = qpigsResponse.getData();
        if (voltronicQpigs3 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("LoadVoltage", (Object)voltronicQpigs3.getLoadVoltage(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs4 = qpigsResponse.getData();
        if (voltronicQpigs4 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("LoadFrequency", (Object)voltronicQpigs4.getLoadFrequency(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs5 = qpigsResponse.getData();
        if (voltronicQpigs5 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("LoadPower", (Object)voltronicQpigs5.getLoadPower(), PointTypeDto.DECIMAL));
        points.add(new PointDto("LoadPowerReal", (Object)loadPowerReal, PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs6 = qpigsResponse.getData();
        if (voltronicQpigs6 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("LoadPercent", (Object)voltronicQpigs6.getLoadPercent(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs7 = qpigsResponse.getData();
        if (voltronicQpigs7 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryVolts", (Object)voltronicQpigs7.getBatteryVoltage(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs8 = qpigsResponse.getData();
        if (voltronicQpigs8 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryAmps", (Object)voltronicQpigs8.getBatteryCurrent(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs9 = qpigsResponse.getData();
        if (voltronicQpigs9 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryPower", (Object)voltronicQpigs9.getBatteryPower(), PointTypeDto.DECIMAL));
        points.add(new PointDto("BatteryPowerReal", (Object)batteryPowerReal, PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs10 = qpigsResponse.getData();
        if (voltronicQpigs10 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatterySocEstimate", (Object)voltronicQpigs10.getBatteryCapacity(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs11 = qpigsResponse.getData();
        if (voltronicQpigs11 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("Temperature", (Object)voltronicQpigs11.getHeatsinkTemperature(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs12 = qpigsResponse.getData();
        if (voltronicQpigs12 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("MpptVolts", (Object)voltronicQpigs12.getMpptVoltage1(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs13 = qpigsResponse.getData();
        if (voltronicQpigs13 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("MpptPower", (Object)voltronicQpigs13.getMpptPower1(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs14 = qpigsResponse.getData();
        if (voltronicQpigs14 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("LoadVolts", (Object)voltronicQpigs14.getLoadVoltage(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs15 = qpigsResponse.getData();
        if (voltronicQpigs15 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("AcChargeEnabled", (Object)voltronicQpigs15.getAcChargeEnabled(), PointTypeDto.INT32));
        VoltronicQpigs voltronicQpigs16 = qpigsResponse.getData();
        if (voltronicQpigs16 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryChargeCurrent", (Object)voltronicQpigs16.getBatteryChargeCurrent(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs17 = qpigsResponse.getData();
        if (voltronicQpigs17 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryDischargeCurrent", (Object)voltronicQpigs17.getBatteryDischargeCurrent(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs18 = qpigsResponse.getData();
        if (voltronicQpigs18 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryVoltsOffset", (Object)voltronicQpigs18.getBatteryVoltageOffset(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs19 = qpigsResponse.getData();
        if (voltronicQpigs19 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryVoltsScc1", (Object)voltronicQpigs19.getBatteryVoltageScc1(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs20 = qpigsResponse.getData();
        if (voltronicQpigs20 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("LoadVolts", (Object)voltronicQpigs20.getBatteryVoltageSteadyUnderCharge(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs21 = qpigsResponse.getData();
        if (voltronicQpigs21 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BusDcVoltage", (Object)voltronicQpigs21.getBusDcVoltage(), PointTypeDto.DECIMAL));
        VoltronicQpigs voltronicQpigs22 = qpigsResponse.getData();
        if (voltronicQpigs22 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("ChargingFloatMode", (Object)voltronicQpigs22.getChargingFloatMode(), PointTypeDto.INT32));
        VoltronicQpigs voltronicQpigs23 = qpigsResponse.getData();
        if (voltronicQpigs23 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("ChargingStatus", (Object)voltronicQpigs23.getChargingStatus(), PointTypeDto.INT32));
        VoltronicQpigs voltronicQpigs24 = qpigsResponse.getData();
        if (voltronicQpigs24 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("ConfigurationUpdated", (Object)voltronicQpigs24.getConfigurationUpdated(), PointTypeDto.INT32));
        VoltronicQpigs voltronicQpigs25 = qpigsResponse.getData();
        if (voltronicQpigs25 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("EepromVersion", (Object)voltronicQpigs25.getEepromVersion(), PointTypeDto.STRING));
        VoltronicQpigs voltronicQpigs26 = qpigsResponse.getData();
        if (voltronicQpigs26 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("PowerSwitchState", (Object)voltronicQpigs26.getPowerSwitchState(), PointTypeDto.INT32));
        VoltronicQpigs voltronicQpigs27 = qpigsResponse.getData();
        if (voltronicQpigs27 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("SbuPriorityVersion", (Object)voltronicQpigs27.getSbuPriorityVersion(), PointTypeDto.INT32));
        QpiriCommandResponse qpiriResponse = this.query(new QpiriCommandRequest());
        VoltronicQpiri voltronicQpiri = qpiriResponse.getData();
        if (voltronicQpiri == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("GridRatingVoltage", (Object)voltronicQpiri.getGridRatingVoltage(), PointTypeDto.DECIMAL));
        VoltronicQpiri voltronicQpiri2 = qpiriResponse.getData();
        if (voltronicQpiri2 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("GridRatingCurrent", (Object)voltronicQpiri2.getGridRatingCurrent(), PointTypeDto.DECIMAL));
        VoltronicQpiri voltronicQpiri3 = qpiriResponse.getData();
        if (voltronicQpiri3 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("LoadOutputRatingVoltage", (Object)voltronicQpiri3.getLoadOutputRatingVoltage(), PointTypeDto.DECIMAL));
        VoltronicQpiri voltronicQpiri4 = qpiriResponse.getData();
        if (voltronicQpiri4 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("LoadOutputRatingFrequency", (Object)voltronicQpiri4.getLoadOutputRatingFrequency(), PointTypeDto.DECIMAL));
        VoltronicQpiri voltronicQpiri5 = qpiriResponse.getData();
        if (voltronicQpiri5 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("LoadOutputRatingCurrent", (Object)voltronicQpiri5.getLoadOutputRatingCurrent(), PointTypeDto.DECIMAL));
        VoltronicQpiri voltronicQpiri6 = qpiriResponse.getData();
        if (voltronicQpiri6 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("LoadOutputRatingApparentPower", (Object)voltronicQpiri6.getLoadOutputRatingApparentPower(), PointTypeDto.INT32));
        VoltronicQpiri voltronicQpiri7 = qpiriResponse.getData();
        if (voltronicQpiri7 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("LoadOutputRatingActivePower", (Object)voltronicQpiri7.getLoadOutputRatingActivePower(), PointTypeDto.INT32));
        VoltronicQpiri voltronicQpiri8 = qpiriResponse.getData();
        if (voltronicQpiri8 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryRatingVoltage", (Object)voltronicQpiri8.getBatteryRatingVoltage(), PointTypeDto.DECIMAL));
        VoltronicQpiri voltronicQpiri9 = qpiriResponse.getData();
        if (voltronicQpiri9 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryReChargeVoltage", (Object)voltronicQpiri9.getBatteryReChargeVoltage(), PointTypeDto.DECIMAL));
        VoltronicQpiri voltronicQpiri10 = qpiriResponse.getData();
        if (voltronicQpiri10 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryUnderVoltage", (Object)voltronicQpiri10.getBatteryUnderVoltage(), PointTypeDto.DECIMAL));
        VoltronicQpiri voltronicQpiri11 = qpiriResponse.getData();
        if (voltronicQpiri11 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryBulkVoltage", (Object)voltronicQpiri11.getBatteryBulkVoltage(), PointTypeDto.DECIMAL));
        VoltronicQpiri voltronicQpiri12 = qpiriResponse.getData();
        if (voltronicQpiri12 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryFloatVoltage", (Object)voltronicQpiri12.getBatteryFloatVoltage(), PointTypeDto.DECIMAL));
        VoltronicQpiri voltronicQpiri13 = qpiriResponse.getData();
        if (voltronicQpiri13 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("BatteryType", (Object)voltronicQpiri13.getBatteryType(), PointTypeDto.STRING));
        VoltronicQpiri voltronicQpiri14 = qpiriResponse.getData();
        if (voltronicQpiri14 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("GridChargingCurrentMax", (Object)voltronicQpiri14.getGridChargingCurrentMax(), PointTypeDto.INT32));
        VoltronicQpiri voltronicQpiri15 = qpiriResponse.getData();
        if (voltronicQpiri15 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("ChargingCurrentMax", (Object)voltronicQpiri15.getChargingCurrentMax(), PointTypeDto.INT32));
        VoltronicQpiri voltronicQpiri16 = qpiriResponse.getData();
        if (voltronicQpiri16 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("InputVoltageRange", (Object)voltronicQpiri16.getInputVoltageRange(), PointTypeDto.STRING));
        VoltronicQpiri voltronicQpiri17 = qpiriResponse.getData();
        if (voltronicQpiri17 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("OutputSourcePriority", (Object)voltronicQpiri17.getOutputSourcePriority(), PointTypeDto.STRING));
        VoltronicQpiri voltronicQpiri18 = qpiriResponse.getData();
        if (voltronicQpiri18 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("ChargerSourcePriority", (Object)voltronicQpiri18.getChargerSourcePriority(), PointTypeDto.STRING));
        VoltronicQpiri voltronicQpiri19 = qpiriResponse.getData();
        if (voltronicQpiri19 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("ParallelMaxNum", (Object)voltronicQpiri19.getParallelMaxNum(), PointTypeDto.INT32));
        VoltronicQpiri voltronicQpiri20 = qpiriResponse.getData();
        if (voltronicQpiri20 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("MachineType", (Object)voltronicQpiri20.getMachineType(), PointTypeDto.STRING));
        VoltronicQpiri voltronicQpiri21 = qpiriResponse.getData();
        if (voltronicQpiri21 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("Topology", (Object)voltronicQpiri21.getTopology(), PointTypeDto.STRING));
        VoltronicQpiri voltronicQpiri22 = qpiriResponse.getData();
        if (voltronicQpiri22 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("OutputMode", (Object)voltronicQpiri22.getOutputMode(), PointTypeDto.STRING));
        VoltronicQpiri voltronicQpiri23 = qpiriResponse.getData();
        if (voltronicQpiri23 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("PvOkCondition", (Object)voltronicQpiri23.getPvOkCondition(), PointTypeDto.STRING));
        VoltronicQpiri voltronicQpiri24 = qpiriResponse.getData();
        if (voltronicQpiri24 == null) {
            Intrinsics.throwNpe();
        }
        points.add(new PointDto("PvPowerBalance", (Object)voltronicQpiri24.getPvPowerBalance(), PointTypeDto.STRING));
        double gridPower = this.calculateGridPower(qpigsResponse, qmodResponse, qpiriResponse);
        points.add(new PointDto("GridPower", (Object)gridPower, PointTypeDto.DECIMAL));
        long end = Instant.now().toEpochMilli();
        this.calculateCumulative(qpigsResponse, points);
        this.getTelemetry().setMeasurement(new MeasurementDto(end - start, Instant.now().toEpochMilli(), points));
    }

    private QpiriCommandResponse query(QpiriCommandRequest qpiriCommandRequest) {
        return new QpiriCommandResponse(this.query(qpiriCommandRequest.toByteBuffer()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateCumulative(QpigsCommandResponse qpigsResponse, List<PointDto> points) {
        Object object = this.cumulativeMutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Optional<Object> storedCoulombs;
            boolean bl3 = false;
            this.getLog().trace('[' + this.getDevice().getName() + "] Locked cumulative calc");
            if (this.batteryCapacityAh == 0.0) {
                this.getLog().debug('[' + this.getDevice().getName() + "] Coulomb counter disabled, set batteryCapacityAh (greater than 0) to enable.");
                return;
            }
            VoltronicCoulombRepository voltronicCoulombRepository = this.coulombRepository;
            if (voltronicCoulombRepository == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"coulombRepository");
            }
            if (!(storedCoulombs = voltronicCoulombRepository.findByName(this.batteryBankName)).isPresent()) {
                this.getLog().trace('[' + this.getDevice().getName() + "] with " + this.batteryBankName + " new StoredCoulombs");
                String string = UUID.randomUUID().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
                ZonedDateTime zonedDateTime = ZonedDateTime.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.now()");
                ZonedDateTime zonedDateTime2 = ZonedDateTime.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime2, (String)"ZonedDateTime.now()");
                CoulombEntity coulombEntity = new CoulombEntity(string, zonedDateTime, zonedDateTime2, null, this.batteryBankName, this.batteryCapacityAh, 100.0);
                VoltronicCoulombRepository voltronicCoulombRepository2 = this.coulombRepository;
                if (voltronicCoulombRepository2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"coulombRepository");
                }
                Optional<Object> optional = Optional.of(voltronicCoulombRepository2.save((Object)coulombEntity));
                Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.of(coulombRepository.save(coulombEntity))");
                storedCoulombs = optional;
            }
            double current = 0.0;
            boolean charging = false;
            VoltronicQpigs voltronicQpigs = qpigsResponse.getData();
            Double d = voltronicQpigs != null ? Double.valueOf(voltronicQpigs.getBatteryPower()) : null;
            if (d == null) {
                Intrinsics.throwNpe();
            }
            if (d >= 0.0) {
                this.getLog().trace('[' + this.getDevice().getName() + "] " + this.batteryBankName + " Battery Charging");
                VoltronicQpigs voltronicQpigs2 = qpigsResponse.getData();
                Double d2 = voltronicQpigs2 != null ? Double.valueOf(voltronicQpigs2.getBatteryCurrent()) : null;
                if (d2 == null) {
                    Intrinsics.throwNpe();
                }
                current = d2;
                charging = true;
            } else {
                VoltronicQpigs voltronicQpigs3 = qpigsResponse.getData();
                Double d3 = voltronicQpigs3 != null ? Double.valueOf(voltronicQpigs3.getBatteryPower()) : null;
                if (d3 == null) {
                    Intrinsics.throwNpe();
                }
                if (d3 <= 0.0) {
                    this.getLog().trace('[' + this.getDevice().getName() + "] " + this.batteryBankName + " Battery Discharging");
                    VoltronicQpigs voltronicQpigs4 = qpigsResponse.getData();
                    Double d4 = voltronicQpigs4 != null ? Double.valueOf(voltronicQpigs4.getBatteryCurrent()) : null;
                    if (d4 == null) {
                        Intrinsics.throwNpe();
                    }
                    current = d4 * (double)-1;
                }
            }
            double coulombs = current * ((double)(this.getDevice().getInterval() / (long)1000) / (double)3600);
            double currentAmpHours = coulombs + ((CoulombEntity)storedCoulombs.get()).getAmpHours();
            if (charging && currentAmpHours > this.batteryCapacityAh) {
                this.getLog().info('[' + this.getDevice().getName() + "] Battery " + this.batteryBankName + " Auto-Calibrated");
                currentAmpHours = this.batteryCapacityAh;
            }
            CoulombEntity coulombEntity = (CoulombEntity)storedCoulombs.get();
            ZonedDateTime zonedDateTime = ZonedDateTime.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.now()");
            coulombEntity.setUpdated(zonedDateTime);
            ((CoulombEntity)storedCoulombs.get()).setAmpHours(currentAmpHours);
            ((CoulombEntity)storedCoulombs.get()).setSoc(currentAmpHours / this.batteryCapacityAh * (double)100);
            VoltronicCoulombRepository voltronicCoulombRepository3 = this.coulombRepository;
            if (voltronicCoulombRepository3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"coulombRepository");
            }
            voltronicCoulombRepository3.save(storedCoulombs.get());
            this.getLog().trace('[' + this.getDevice().getName() + "] " + this.batteryBankName + " Current: " + current + ", Interval: " + this.getDevice().getInterval() + ", StoredCoulombs" + ".ampHours: " + ((CoulombEntity)storedCoulombs.get()).getAmpHours() + " Coulombs: " + coulombs + " Percent: " + ((CoulombEntity)storedCoulombs.get()).getSoc());
            double estimatedTimeToRechargedMin = 0.0;
            double estimatedTimeToDischargedMin = 0.0;
            if (charging) {
                estimatedTimeToRechargedMin = (this.batteryCapacityAh - currentAmpHours) / current * (double)60;
            } else {
                estimatedTimeToDischargedMin = currentAmpHours / (current * (double)-1) * (double)60;
            }
            points.add(new PointDto("BatteryBankName", (Object)this.batteryBankName, PointTypeDto.STRING));
            points.add(new PointDto("BatteryChargeAh", (Object)((CoulombEntity)storedCoulombs.get()).getAmpHours(), PointTypeDto.DECIMAL));
            points.add(new PointDto("BatterySoC", (Object)((CoulombEntity)storedCoulombs.get()).getSoc(), PointTypeDto.DECIMAL));
            points.add(new PointDto("BatteryCapacityAh", (Object)this.batteryCapacityAh, PointTypeDto.DECIMAL));
            points.add(new PointDto("BatteryTimeToDischargedMin", (Object)estimatedTimeToDischargedMin, PointTypeDto.DECIMAL));
            points.add(new PointDto("BatteryTimeToRechargedMin", (Object)estimatedTimeToRechargedMin, PointTypeDto.DECIMAL));
            bl2 = points.add(new PointDto("BatteryDepthOfDischarge", (Object)this.batteryBankDod, PointTypeDto.DECIMAL));
        }
    }

    public void validate() {
    }

    public void destroy() {
        this.reading = false;
    }

    private QmodCommandResponse query(QmodCommandRequest qmodCommandRequest) {
        return new QmodCommandResponse(this.query(qmodCommandRequest.toByteBuffer()));
    }

    private double calculateGridPower(QpigsCommandResponse qpigsResponse, QmodCommandResponse qmodResponse, QpiriCommandResponse qpiriResponse) {
        double gridPower = 0.0;
        if (this.newGridPowerAlgorithm) {
            VoltronicQpigs voltronicQpigs = qpigsResponse.getData();
            if (voltronicQpigs == null) {
                Intrinsics.throwNpe();
            }
            double d = this.inverterBaseLoad + voltronicQpigs.getLoadPower() * this.loadLossMultiplier;
            VoltronicQpigs voltronicQpigs2 = qpigsResponse.getData();
            if (voltronicQpigs2 == null) {
                Intrinsics.throwNpe();
            }
            double loads = d + voltronicQpigs2.getBatteryPower() * this.batteryLossMultiplier;
            VoltronicQpigs voltronicQpigs3 = qpigsResponse.getData();
            if (voltronicQpigs3 == null) {
                Intrinsics.throwNpe();
            }
            gridPower = loads - voltronicQpigs3.getMpptPower1() * this.mpptLossMultiplier;
            if (!StringsKt.equals((String)qmodResponse.getMode(), (String)"Line Mode", (boolean)true)) {
                gridPower = 0.0;
            }
        } else if (StringsKt.equals((String)qmodResponse.getMode(), (String)"Line Mode", (boolean)true)) {
            VoltronicQpiri voltronicQpiri = qpiriResponse.getData();
            if (voltronicQpiri == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual((Object)voltronicQpiri.getChargerSourcePriority(), (Object)"0")) {
                VoltronicQpigs voltronicQpigs = qpigsResponse.getData();
                if (voltronicQpigs == null) {
                    Intrinsics.throwNpe();
                }
                double d = this.inverterBaseLoad + voltronicQpigs.getLoadPower();
                VoltronicQpigs voltronicQpigs4 = qpigsResponse.getData();
                if (voltronicQpigs4 == null) {
                    Intrinsics.throwNpe();
                }
                gridPower = d + voltronicQpigs4.getBatteryPower();
            } else {
                VoltronicQpigs voltronicQpigs = qpigsResponse.getData();
                if (voltronicQpigs == null) {
                    Intrinsics.throwNpe();
                }
                gridPower = this.inverterBaseLoad + voltronicQpigs.getLoadPower();
            }
        }
        return gridPower;
    }

    private double calculateBatteryPowerReal(QpigsCommandResponse qpigsResponse) {
        double d;
        VoltronicQpigs voltronicQpigs = qpigsResponse.getData();
        if (voltronicQpigs == null) {
            Intrinsics.throwNpe();
        }
        if (voltronicQpigs.getBatteryPower() > 0.0) {
            VoltronicQpigs voltronicQpigs2 = qpigsResponse.getData();
            if (voltronicQpigs2 == null) {
                Intrinsics.throwNpe();
            }
            d = voltronicQpigs2.getBatteryPower() + this.inverterBaseLoad;
        } else {
            VoltronicQpigs voltronicQpigs3 = qpigsResponse.getData();
            if (voltronicQpigs3 == null) {
                Intrinsics.throwNpe();
            }
            if (voltronicQpigs3.getBatteryPower() == 0.0) {
                d = 0.0;
            } else {
                VoltronicQpigs voltronicQpigs4 = qpigsResponse.getData();
                if (voltronicQpigs4 == null) {
                    Intrinsics.throwNpe();
                }
                d = voltronicQpigs4.getBatteryPower() - this.inverterBaseLoad;
            }
        }
        return d;
    }

    private double calculateLoadPowerReal(QpigsCommandResponse qpigsResponse) {
        double d;
        VoltronicQpigs voltronicQpigs = qpigsResponse.getData();
        if (voltronicQpigs == null) {
            Intrinsics.throwNpe();
        }
        if (voltronicQpigs.getLoadPower() > 0.0) {
            VoltronicQpigs voltronicQpigs2 = qpigsResponse.getData();
            if (voltronicQpigs2 == null) {
                Intrinsics.throwNpe();
            }
            d = voltronicQpigs2.getLoadPower() + this.inverterBaseLoad;
        } else {
            VoltronicQpigs voltronicQpigs3 = qpigsResponse.getData();
            if (voltronicQpigs3 == null) {
                Intrinsics.throwNpe();
            }
            if (voltronicQpigs3.getLoadPower() == 0.0) {
                d = 0.0;
            } else {
                VoltronicQpigs voltronicQpigs4 = qpigsResponse.getData();
                if (voltronicQpigs4 == null) {
                    Intrinsics.throwNpe();
                }
                d = voltronicQpigs4.getLoadPower() - this.inverterBaseLoad;
            }
        }
        return d;
    }

    private QpigsCommandResponse query(QpigsCommandRequest command) {
        return new QpigsCommandResponse(this.query(command.toByteBuffer()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized byte[] query(ByteBuffer commandBuffer) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Closeable it2;
        FileOutputStream outputStream = new FileOutputStream(this.port);
        FileInputStream inputStream = new FileInputStream(this.port);
        Closeable closeable = outputStream;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            it2 = (FileOutputStream)closeable;
            boolean bl3 = false;
            try {
                Logger logger = this.getLog();
                StringBuilder stringBuilder = new StringBuilder().append("VoltronicMKS: Write: [").append(commandBuffer.array().length).append("] [UTF8] [");
                byte[] byArray = commandBuffer.array();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"commandBuffer.array()");
                Object object4 = byArray;
                object3 = stringBuilder;
                object2 = logger;
                boolean bl4 = false;
                object = new String((byte[])object4, Charsets.UTF_8);
                object2.debug(((StringBuilder)object3).append((String)object).append(']').toString());
                Logger logger2 = this.getLog();
                StringBuilder stringBuilder2 = new StringBuilder().append("VoltronicMKS: Write: [").append(commandBuffer.array().length).append("] [ HEX] [0x");
                char[] cArray = Hex.encodeHex((byte[])commandBuffer.array());
                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"Hex.encodeHex(\n         \u2026                        )");
                object4 = cArray;
                object3 = stringBuilder2;
                object2 = logger2;
                bl4 = false;
                object = new String((char[])object4);
                object4 = object;
                bl4 = false;
                String string = ((String)object4).toUpperCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toUpperCase()");
                object = string;
                object2.debug(((StringBuilder)object3).append((String)object).append(']').toString());
                ((FileOutputStream)it2).write(commandBuffer.array());
                ((OutputStream)it2).flush();
            }
            catch (IOException e) {
                Logger logger = this.getLog();
                StringBuilder stringBuilder = new StringBuilder().append("VoltronicMKS: Query Exception [");
                byte[] byArray = commandBuffer.array();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"commandBuffer.array()");
                byte[] byArray2 = byArray;
                object3 = stringBuilder;
                object2 = logger;
                bl = false;
                object = new String(byArray2, Charsets.UTF_8);
                object2.error(((StringBuilder)object3).append((String)object).append("] - ").append(e.getMessage()).toString(), (Throwable)e);
            }
            catch (VoltronicException v) {
                Logger logger = this.getLog();
                StringBuilder stringBuilder = new StringBuilder().append("VoltronicMKS: Query Exception [");
                byte[] byArray = commandBuffer.array();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"commandBuffer.array()");
                byte[] byArray3 = byArray;
                object3 = stringBuilder;
                object2 = logger;
                bl = false;
                object = new String(byArray3, Charsets.UTF_8);
                object2.error(((StringBuilder)object3).append((String)object).append("] - ").append(v.getMessage()).toString());
            }
            catch (Exception e) {
                Logger logger = this.getLog();
                StringBuilder stringBuilder = new StringBuilder().append("VoltronicMKS: Query [");
                byte[] byArray = commandBuffer.array();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"commandBuffer.array()");
                byte[] byArray4 = byArray;
                object3 = stringBuilder;
                object2 = logger;
                bl = false;
                object = new String(byArray4, Charsets.UTF_8);
                object2.error(((StringBuilder)object3).append((String)object).append("] Exception - ").append(e.getMessage()).toString(), (Throwable)e);
            }
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.getLog().debug("VoltronicMKS: Write Complete, Preparing Read");
        closeable = inputStream;
        bl2 = false;
        throwable = null;
        try {
            it2 = (FileInputStream)closeable;
            boolean bl5 = false;
            byte[] buffer = null;
            object3 = inputStream;
            object = Charsets.UTF_8;
            bl = false;
            Object object5 = object3;
            int n = 0;
            object5 = new InputStreamReader((InputStream)object5, (Charset)object);
            n = 8192;
            boolean bl6 = false;
            Object object6 = object5 instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, n);
            Reader reader = (Reader)object6;
            CancelableReader reader2 = new CancelableReader(reader);
            new Thread((Runnable)new query$$inlined$use$lambda$1(reader2, this, inputStream)).start();
            String string = reader2.readLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.readLine()");
            object3 = string;
            object = Charsets.UTF_8;
            bl = false;
            Object object7 = object3;
            if (object7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = ((String)object7).getBytes((Charset)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            buffer = byArray;
            object3 = buffer;
            boolean bl7 = false;
            if (!(((Object)object3).length == 0)) {
                object2 = new StringBuilder().append("VoltronicMKS: Read [").append(buffer.length).append("] [UTF8] [");
                Logger logger = this.getLog();
                boolean bl8 = false;
                object6 = new String(buffer, Charsets.UTF_8);
                logger.debug(((StringBuilder)object2).append((String)object6).append(']').toString());
                this.getLog().debug("VoltronicMKS: Read [" + buffer.length + "] [HEX] [0x" + Hex.encodeHexString((byte[])buffer) + ']');
                if ((char)buffer[0] != '(') {
                    throw (Throwable)new VoltronicReadException("Invalid start bytes.");
                }
                bl8 = false;
                if (StringsKt.contains$default((CharSequence)new String(buffer, Charsets.UTF_8), (CharSequence)"NAK", (boolean)false, (int)2, null)) {
                    throw (Throwable)new VoltronicReadException("Invalid response (NAK).");
                }
                this.getLog().debug("VoltronicMKS: Read Complete");
                byte[] byArray5 = buffer;
                return byArray5;
            }
            try {
                throw (Throwable)new VoltronicReadException("Read Timeout");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public Logger getLog() {
        return this.log;
    }

    private AnonymousCommandResponse query(AnonymousCommandRequest anonymousCommandRequest) {
        return new AnonymousCommandResponse(this.query(anonymousCommandRequest.toByteBuffer()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEventReceived(@NotNull EventRequestModel eventRequest) {
        Intrinsics.checkParameterIsNotNull((Object)eventRequest, (String)"eventRequest");
        String topic = eventRequest.getTopic();
        if (StringsKt.contains$default((CharSequence)topic, (CharSequence)this.getDevice().getName(), (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)topic, (String)"/request", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)topic, (CharSequence)"/response", (boolean)false, (int)2, null)) {
            List split = StringsKt.split$default((CharSequence)topic, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
            String command = (String)split.get(split.size() - 2);
            this.getLog().info('[' + this.getDevice().getName() + "] Voltronic Event: Topic=[" + eventRequest.getTopic() + "] Payload=[" + eventRequest.getPayload() + "] Command=[" + command + ']');
            this.getLog().debug('[' + this.getDevice().getName() + "] Voltronic Instance  [" + this + ']');
            Future<?> result = null;
            try {
                result = this.workerExecutor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                result.get(this.getDevice().getTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                this.getLog().error('[' + this.getDevice().getName() + "] Voltronic - Event Worker Timeout: [" + this.getDevice().getName() + "] [" + e.getClass().getSimpleName() + "] (" + e.getMessage() + ')');
                Future<?> future = result;
                if (future != null) {
                    future.cancel(true);
                }
            }
            finally {
                this.getDevice().getDriver().release();
            }
        }
    }

    @NotNull
    public DeviceModel getDevice() {
        return this.device;
    }

    public void setDevice(@NotNull DeviceModel deviceModel) {
        Intrinsics.checkParameterIsNotNull((Object)deviceModel, (String)"<set-?>");
        this.device = deviceModel;
    }

    public VoltronicMksDriver(@NotNull DeviceModel device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        super(device, null, 2, null);
        this.device = device;
        this.cumulativeMutex = new Object();
        this.batteryLossMultiplier = 0.96;
        this.loadLossMultiplier = 1.04;
        this.mpptLossMultiplier = 0.92;
        this.newGridPowerAlgorithm = true;
        this.port = "/dev/hidraw0";
        this.batteryBankName = this.getDevice().getName();
        this.batteryBankDod = 10.0;
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.now()");
        this.updated = zonedDateTime;
        this.workerExecutor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("voltronic-evnt-"));
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(this.javaClass)");
        this.log = logger;
    }

    public static final /* synthetic */ AnonymousCommandResponse access$query(VoltronicMksDriver $this, AnonymousCommandRequest anonymousCommandRequest) {
        return $this.query(anonymousCommandRequest);
    }
}

