/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.driver.victron;

import io.gritlabs.probe.domain.driver.PollingDriver;
import io.gritlabs.probe.domain.driver.Status;
import io.gritlabs.probe.domain.driver.victron.BmvProtocol;
import io.gritlabs.probe.domain.service.dto.MeasurementDto;
import io.gritlabs.probe.domain.service.dto.PointDto;
import io.gritlabs.probe.domain.service.dto.PointTypeDto;
import io.gritlabs.probe.domain.service.model.DeviceModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0017J,\u0010\u001a\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0012J\b\u0010\"\u001a\u00020\u0018H\u0016J\u0018\u0010#\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020%H\u0012J\b\u0010&\u001a\u00020\u0018H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/gritlabs/probe/domain/driver/victron/VictronBmvDriver;", "Lio/gritlabs/probe/domain/driver/PollingDriver;", "device", "Lio/gritlabs/probe/domain/service/model/DeviceModel;", "(Lio/gritlabs/probe/domain/service/model/DeviceModel;)V", "getDevice", "()Lio/gritlabs/probe/domain/service/model/DeviceModel;", "setDevice", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "port", "", "updated", "Ljava/time/ZonedDateTime;", "getUpdated", "()Ljava/time/ZonedDateTime;", "setUpdated", "(Ljava/time/ZonedDateTime;)V", "workerExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "destroy", "", "init", "parse", "lines", "", "points", "", "Lio/gritlabs/probe/domain/service/dto/PointDto;", "start", "", "process", "read", "bmvFile", "Ljava/io/File;", "validate", "grit-probe"})
public class VictronBmvDriver
extends PollingDriver {
    private String port;
    @NotNull
    private ZonedDateTime updated;
    private final ExecutorService workerExecutor;
    @NotNull
    private final Logger log;
    @NotNull
    private DeviceModel device;

    @NotNull
    public ZonedDateTime getUpdated() {
        return this.updated;
    }

    public void setUpdated(@NotNull ZonedDateTime zonedDateTime) {
        Intrinsics.checkParameterIsNotNull((Object)zonedDateTime, (String)"<set-?>");
        this.updated = zonedDateTime;
    }

    @PostConstruct
    public void init() {
        if (!this.getDevice().getEnabled()) {
            this.setStatus(Status.DISABLED.toString());
            return;
        }
        this.port = String.valueOf(this.getDevice().getParameters().get((Object)"port"));
        this.getLog().debug("VictronBmv: Acquiring file [" + this.port + "] handle...");
        File bmvFile = new File(this.port);
        this.getLog().debug("VictronBmv: Acquired file [" + this.port + "] handle");
        this.workerExecutor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.getLog().debug("VictronBmv: Initialized.");
    }

    @NotNull
    public Logger getLog() {
        return this.log;
    }

    public synchronized void process() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(List<String> lines, List<PointDto> points, long start) {
        try {
            for (String line : lines) {
                List labelValue;
                if (StringsKt.isBlank((CharSequence)line)) continue;
                this.getLog().debug("VictronBmv: Parse - content=[" + line + "]  len=[" + line.length() + ']');
                CharSequence charSequence = line;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)charSequence)) || (labelValue = StringsKt.split$default((CharSequence)line, (String[])new String[]{"\t"}, (boolean)false, (int)0, (int)6, null)).size() <= 1) continue;
                String label = (String)labelValue.get(0);
                String value = (String)labelValue.get(1);
                if (Intrinsics.areEqual((Object)label, (Object)"Checksum")) continue;
                String mappedLabel = BmvProtocol.INSTANCE.mapLabel(label);
                CharSequence charSequence2 = mappedLabel;
                boolean bl2 = false;
                boolean bl3 = false;
                if (charSequence2 == null || charSequence2.length() == 0) continue;
                Pair parsedValue = BmvProtocol.INSTANCE.parseValue(label, value);
                if (!points.stream().anyMatch((Predicate)new /* Unavailable Anonymous Inner Class!! */)) {
                    points.add(new PointDto(mappedLabel, parsedValue.getFirst(), (PointTypeDto)parsedValue.getSecond()));
                    continue;
                }
                points.removeIf((Predicate)new /* Unavailable Anonymous Inner Class!! */);
                points.add(new PointDto(mappedLabel, parsedValue.getFirst(), (PointTypeDto)parsedValue.getSecond()));
            }
        }
        catch (Exception e) {
            this.getLog().error("VictronBmv - Parse Exception - {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            long end = Instant.now().toEpochMilli();
            this.getTelemetry().setMeasurement(new MeasurementDto(end - start, Instant.now().toEpochMilli(), points));
        }
    }

    private List<String> read(File bmvFile) {
        int chunkCount = 0;
        this.getLog().debug("VictronBmv: [" + chunkCount + "] Reading...");
        File file = bmvFile;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object = file;
        boolean bl2 = false;
        Object object2 = object;
        boolean bl3 = false;
        object2 = new FileInputStream((File)object2);
        bl3 = false;
        object = new InputStreamReader((InputStream)object2, charset);
        bl2 = false;
        List<String> lines = (object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)).lines().limit(60L).collect(Collectors.toList());
        return lines;
    }

    public void validate() {
    }

    public void destroy() {
    }

    @NotNull
    public DeviceModel getDevice() {
        return this.device;
    }

    public void setDevice(@NotNull DeviceModel deviceModel) {
        Intrinsics.checkParameterIsNotNull((Object)deviceModel, (String)"<set-?>");
        this.device = deviceModel;
    }

    public VictronBmvDriver(@NotNull DeviceModel device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        super(device, null, 2, null);
        this.device = device;
        this.port = "/dev/ttyUSB0";
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.now()");
        this.updated = zonedDateTime;
        this.workerExecutor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("bmv-worker-"));
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(this.javaClass)");
        this.log = logger;
    }

    public static final /* synthetic */ List access$read(VictronBmvDriver $this, File bmvFile) {
        return $this.read(bmvFile);
    }

    public static final /* synthetic */ void access$parse(VictronBmvDriver $this, List lines, List points, long start) {
        $this.parse(lines, points, start);
    }
}

