/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.driver.victron;

import io.gritlabs.probe.domain.service.dto.PointTypeDto;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b)\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u00101\u001a\u0004\u0018\u00010\u00042\u0006\u00102\u001a\u00020\u0004J\"\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u000205042\u0006\u00102\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lio/gritlabs/probe/domain/driver/victron/BmvProtocol;", "", "()V", "CHECKSUM", "", "DELIMITER", "NEWLINE", "VEDIRECT_ALARM", "VEDIRECT_BMV", "VEDIRECT_CE", "VEDIRECT_CS", "VEDIRECT_ERR", "VEDIRECT_FW", "VEDIRECT_H1", "VEDIRECT_H10", "VEDIRECT_H11", "VEDIRECT_H12", "VEDIRECT_H15", "VEDIRECT_H16", "VEDIRECT_H17", "VEDIRECT_H18", "VEDIRECT_H19", "VEDIRECT_H2", "VEDIRECT_H20", "VEDIRECT_H21", "VEDIRECT_H22", "VEDIRECT_H23", "VEDIRECT_H3", "VEDIRECT_H4", "VEDIRECT_H5", "VEDIRECT_H6", "VEDIRECT_H7", "VEDIRECT_H8", "VEDIRECT_H9", "VEDIRECT_HSDS", "VEDIRECT_I", "VEDIRECT_MODE", "VEDIRECT_P", "VEDIRECT_PID", "VEDIRECT_RELAY", "VEDIRECT_SER", "VEDIRECT_SOC", "VEDIRECT_T", "VEDIRECT_TTG", "VEDIRECT_V", "fields", "", "log", "Lorg/slf4j/Logger;", "mapLabel", "label", "parseValue", "Lkotlin/Pair;", "Lio/gritlabs/probe/domain/service/dto/PointTypeDto;", "value", "grit-probe"})
public final class BmvProtocol {
    @NotNull
    public static final String NEWLINE = "\n";
    @NotNull
    public static final String CHECKSUM = "Checksum";
    private static final Logger log;
    private static final String VEDIRECT_V = "V";
    private static final String VEDIRECT_T = "T";
    private static final String VEDIRECT_I = "I";
    private static final String VEDIRECT_P = "P";
    private static final String VEDIRECT_CE = "CE";
    private static final String VEDIRECT_SOC = "SOC";
    private static final String VEDIRECT_TTG = "TTG";
    private static final String VEDIRECT_ALARM = "Alarm";
    private static final String VEDIRECT_BMV = "BMV";
    private static final String VEDIRECT_FW = "FW";
    private static final String VEDIRECT_H1 = "H1";
    private static final String VEDIRECT_H2 = "H2";
    private static final String VEDIRECT_H3 = "H3";
    private static final String VEDIRECT_H4 = "H4";
    private static final String VEDIRECT_H5 = "H5";
    private static final String VEDIRECT_H6 = "H6";
    private static final String VEDIRECT_H7 = "H7";
    private static final String VEDIRECT_H8 = "H8";
    private static final String VEDIRECT_H9 = "H9";
    private static final String VEDIRECT_H10 = "H10";
    private static final String VEDIRECT_H11 = "H11";
    private static final String VEDIRECT_H12 = "H12";
    private static final String VEDIRECT_H15 = "H15";
    private static final String VEDIRECT_H16 = "H16";
    private static final String VEDIRECT_H17 = "H17";
    private static final String VEDIRECT_H18 = "H18";
    private static final String VEDIRECT_H19 = "H19";
    private static final String VEDIRECT_H20 = "H20";
    private static final String VEDIRECT_H21 = "H21";
    private static final String VEDIRECT_H22 = "H22";
    private static final String VEDIRECT_H23 = "H23";
    private static final String VEDIRECT_ERR = "ERR";
    private static final String VEDIRECT_CS = "CS";
    private static final String VEDIRECT_PID = "PID";
    private static final String VEDIRECT_SER = "SER#";
    private static final String VEDIRECT_HSDS = "HSDS";
    private static final String VEDIRECT_MODE = "MODE";
    private static final String VEDIRECT_RELAY = "Relay";
    @NotNull
    public static final String DELIMITER = "\t";
    private static final List<String> fields;
    public static final BmvProtocol INSTANCE;

    @Nullable
    public final String mapLabel(@NotNull String label) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        if (Intrinsics.areEqual((Object)VEDIRECT_V, (Object)label)) {
            return "BatteryVoltage";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_T, (Object)label)) {
            return "BatteryTemperature";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_I, (Object)label)) {
            return "BatteryCurrent";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_P, (Object)label)) {
            return "BatteryPower";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_CE, (Object)label)) {
            return "ConsumedAmpHours";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_SOC, (Object)label)) {
            return "StateOfCharge";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_TTG, (Object)label)) {
            return "TimeRemainingMinutes";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_ALARM, (Object)label)) {
            return "AlarmCondition";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_BMV, (Object)label)) {
            return "ModelDescription";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_FW, (Object)label)) {
            return "FirmwareVersion";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H1, (Object)label)) {
            return "DeepestDepthOfDischargeAmpHours";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H2, (Object)label)) {
            return "DepthOfLastDischargeAmpHours";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H3, (Object)label)) {
            return "DepthOfAverageDischargeAmpHours";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H4, (Object)label)) {
            return "ChargeCyclesCount";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H5, (Object)label)) {
            return "FullDischargeCount";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H6, (Object)label)) {
            return "CumulativeAmpHoursDrawn";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H7, (Object)label)) {
            return "MinBatteryVoltage";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H8, (Object)label)) {
            return "MaxBatteryVoltage";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H9, (Object)label)) {
            return "CurrentDischargeCycleDurationSeconds";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H10, (Object)label)) {
            return "AutomaticSynchronizationCount";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H11, (Object)label)) {
            return "LowMainVoltageAlarmCount";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H12, (Object)label)) {
            return "HighMainVoltageAlarmCount";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H15, (Object)label)) {
            return "MinAuxBatteryVoltage";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H16, (Object)label)) {
            return "MaxAuxBatteryVoltage";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H17, (Object)label)) {
            return "AmountDischargedEnergyKWh";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H18, (Object)label)) {
            return "AmountChargedEnergyKWh";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H19, (Object)label)) {
            return "YieldTotalKWh";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H20, (Object)label)) {
            return "YieldTodayKWh";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H21, (Object)label)) {
            return "MaxPowerTodayWatts";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H22, (Object)label)) {
            return "YieldYesterdayKWh";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_H23, (Object)label)) {
            return "MaximumPowerYesterdayWatts";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_ERR, (Object)label)) {
            return "ErrorCode";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_CS, (Object)label)) {
            return "StateOfOperation";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_PID, (Object)label)) {
            return "ProductId";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_SER, (Object)label)) {
            return "SerialNumber";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_HSDS, (Object)label)) {
            return "DaySequenceNumber";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_MODE, (Object)label)) {
            return "DeviceMode";
        }
        if (Intrinsics.areEqual((Object)VEDIRECT_RELAY, (Object)label)) {
            return "RelayState";
        }
        return null;
    }

    @NotNull
    public final Pair<Object, PointTypeDto> parseValue(@NotNull String label, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        try {
            Pair pair;
            switch (label) {
                case "V": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d2 = d / (double)1000;
                    pair = new Pair((Object)d2, (Object)pointTypeDto);
                    break;
                }
                case "T": {
                    if (!StringsKt.contains$default((CharSequence)value, (CharSequence)"-", (boolean)false, (int)2, null)) {
                        String string = value;
                        boolean bl = false;
                        double d = Double.parseDouble(string);
                        PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                        Double d3 = d;
                        return new Pair((Object)d3, (Object)pointTypeDto);
                    }
                    return new Pair((Object)value, (Object)PointTypeDto.STRING);
                }
                case "I": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d4 = d / (double)1000;
                    pair = new Pair((Object)d4, (Object)pointTypeDto);
                    break;
                }
                case "P": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d5 = d;
                    pair = new Pair((Object)d5, (Object)pointTypeDto);
                    break;
                }
                case "CE": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d6 = d;
                    pair = new Pair((Object)d6, (Object)pointTypeDto);
                    break;
                }
                case "SOC": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d7 = d / (double)10;
                    pair = new Pair((Object)d7, (Object)pointTypeDto);
                    break;
                }
                case "H1": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d8 = d / (double)1000;
                    pair = new Pair((Object)d8, (Object)pointTypeDto);
                    break;
                }
                case "H2": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d9 = d / (double)1000;
                    pair = new Pair((Object)d9, (Object)pointTypeDto);
                    break;
                }
                case "H3": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d10 = d;
                    pair = new Pair((Object)d10, (Object)pointTypeDto);
                    break;
                }
                case "H4": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d11 = d;
                    pair = new Pair((Object)d11, (Object)pointTypeDto);
                    break;
                }
                case "H5": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d12 = d;
                    pair = new Pair((Object)d12, (Object)pointTypeDto);
                    break;
                }
                case "H6": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d13 = d / (double)100;
                    pair = new Pair((Object)d13, (Object)pointTypeDto);
                    break;
                }
                case "H7": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d14 = d / (double)1000;
                    pair = new Pair((Object)d14, (Object)pointTypeDto);
                    break;
                }
                case "H8": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d15 = d / (double)1000;
                    pair = new Pair((Object)d15, (Object)pointTypeDto);
                    break;
                }
                case "H9": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d16 = d;
                    pair = new Pair((Object)d16, (Object)pointTypeDto);
                    break;
                }
                case "H10": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d17 = d;
                    pair = new Pair((Object)d17, (Object)pointTypeDto);
                    break;
                }
                case "H11": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d18 = d;
                    pair = new Pair((Object)d18, (Object)pointTypeDto);
                    break;
                }
                case "H12": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d19 = d;
                    pair = new Pair((Object)d19, (Object)pointTypeDto);
                    break;
                }
                case "H15": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d20 = d;
                    pair = new Pair((Object)d20, (Object)pointTypeDto);
                    break;
                }
                case "H16": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d21 = d;
                    pair = new Pair((Object)d21, (Object)pointTypeDto);
                    break;
                }
                case "H17": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d22 = d;
                    pair = new Pair((Object)d22, (Object)pointTypeDto);
                    break;
                }
                case "H18": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d23 = d;
                    pair = new Pair((Object)d23, (Object)pointTypeDto);
                    break;
                }
                case "H19": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d24 = d;
                    pair = new Pair((Object)d24, (Object)pointTypeDto);
                    break;
                }
                case "H20": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d25 = d;
                    pair = new Pair((Object)d25, (Object)pointTypeDto);
                    break;
                }
                case "H21": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d26 = d;
                    pair = new Pair((Object)d26, (Object)pointTypeDto);
                    break;
                }
                case "H22": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d27 = d;
                    pair = new Pair((Object)d27, (Object)pointTypeDto);
                    break;
                }
                case "H23": {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d28 = d;
                    pair = new Pair((Object)d28, (Object)pointTypeDto);
                    break;
                }
                case "Alarm": {
                    pair = new Pair((Object)value, (Object)PointTypeDto.STRING);
                    break;
                }
                case "BMV": {
                    pair = new Pair((Object)value, (Object)PointTypeDto.STRING);
                    break;
                }
                case "Relay": {
                    pair = new Pair((Object)value, (Object)PointTypeDto.STRING);
                    break;
                }
                case "PID": {
                    pair = new Pair((Object)value, (Object)PointTypeDto.STRING);
                    break;
                }
                case "TTG": {
                    String string = value;
                    boolean bl = false;
                    int n = Integer.parseInt(string);
                    PointTypeDto pointTypeDto = PointTypeDto.INT32;
                    Integer n2 = n;
                    pair = new Pair((Object)n2, (Object)pointTypeDto);
                    break;
                }
                default: {
                    String string = value;
                    boolean bl = false;
                    double d = Double.parseDouble(string);
                    PointTypeDto pointTypeDto = PointTypeDto.DECIMAL;
                    Double d29 = d;
                    pair = new Pair((Object)d29, (Object)pointTypeDto);
                }
            }
            return pair;
        }
        catch (Exception e) {
            log.error("VictronBmv: Protocol Error (Parsing [{}] [{}]) - {}", new Object[]{label, value, e.getMessage()});
            return new Pair((Object)value, (Object)PointTypeDto.STRING);
        }
    }

    private BmvProtocol() {
    }

    static {
        BmvProtocol bmvProtocol;
        INSTANCE = bmvProtocol = new BmvProtocol();
        Logger logger = LoggerFactory.getLogger(bmvProtocol.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(this.javaClass)");
        log = logger;
        fields = CollectionsKt.mutableListOf((Object[])new String[]{VEDIRECT_V, VEDIRECT_T, VEDIRECT_I, VEDIRECT_P, VEDIRECT_CE, VEDIRECT_SOC, VEDIRECT_TTG, VEDIRECT_ALARM, VEDIRECT_BMV, VEDIRECT_FW, VEDIRECT_H1, VEDIRECT_H2, VEDIRECT_H3, VEDIRECT_H4, VEDIRECT_H5, VEDIRECT_H6, VEDIRECT_H7, VEDIRECT_H8, VEDIRECT_H9, VEDIRECT_H10, VEDIRECT_H11, VEDIRECT_H12, VEDIRECT_H15, VEDIRECT_H16, VEDIRECT_H17, VEDIRECT_H18, VEDIRECT_H19, VEDIRECT_H20, VEDIRECT_H21, VEDIRECT_H22, VEDIRECT_H23, VEDIRECT_ERR, VEDIRECT_CS, VEDIRECT_PID, VEDIRECT_SER, VEDIRECT_HSDS, VEDIRECT_MODE, VEDIRECT_RELAY});
    }
}

