/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.driver;

import io.gritlabs.probe.domain.driver.Status;
import io.gritlabs.probe.domain.service.dto.MeasurementDto;
import io.gritlabs.probe.domain.service.dto.TelemetryDto;
import io.gritlabs.probe.domain.service.model.DeviceModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\"H&J\b\u0010#\u001a\u00020\"H&J\b\u0010$\u001a\u00020\"H&J\u0006\u0010%\u001a\u00020\"J\b\u0010&\u001a\u00020\"H&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u00020\u001aX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006'"}, d2={"Lio/gritlabs/probe/domain/driver/PollingDriver;", "", "device", "Lio/gritlabs/probe/domain/service/model/DeviceModel;", "telemetry", "Lio/gritlabs/probe/domain/service/dto/TelemetryDto;", "(Lio/gritlabs/probe/domain/service/model/DeviceModel;Lio/gritlabs/probe/domain/service/dto/TelemetryDto;)V", "getDevice", "()Lio/gritlabs/probe/domain/service/model/DeviceModel;", "semaphore", "Ljava/util/concurrent/Semaphore;", "getSemaphore", "()Ljava/util/concurrent/Semaphore;", "semaphoreExhaustionCount", "Ljava/util/concurrent/atomic/AtomicLong;", "getSemaphoreExhaustionCount", "()Ljava/util/concurrent/atomic/AtomicLong;", "status", "", "getStatus", "()Ljava/lang/String;", "setStatus", "(Ljava/lang/String;)V", "getTelemetry", "()Lio/gritlabs/probe/domain/service/dto/TelemetryDto;", "updated", "Ljava/time/ZonedDateTime;", "getUpdated", "()Ljava/time/ZonedDateTime;", "setUpdated", "(Ljava/time/ZonedDateTime;)V", "acquire", "", "destroy", "", "init", "process", "release", "validate", "grit-probe"})
public abstract class PollingDriver {
    @NotNull
    private String status;
    @NotNull
    private final Semaphore semaphore;
    @NotNull
    private final AtomicLong semaphoreExhaustionCount;
    @NotNull
    private final DeviceModel device;
    @NotNull
    private final TelemetryDto telemetry;

    @NotNull
    public abstract ZonedDateTime getUpdated();

    public abstract void setUpdated(@NotNull ZonedDateTime var1);

    @NotNull
    public final String getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.status = string;
    }

    @NotNull
    public final Semaphore getSemaphore() {
        return this.semaphore;
    }

    @NotNull
    public final AtomicLong getSemaphoreExhaustionCount() {
        return this.semaphoreExhaustionCount;
    }

    public abstract void init();

    public abstract void process();

    public final boolean acquire() {
        return this.semaphore.tryAcquire(1, 10L, TimeUnit.SECONDS);
    }

    public final void release() {
        this.semaphore.release();
    }

    public abstract void validate();

    public abstract void destroy();

    @NotNull
    public DeviceModel getDevice() {
        return this.device;
    }

    @NotNull
    public final TelemetryDto getTelemetry() {
        return this.telemetry;
    }

    public PollingDriver(@NotNull DeviceModel device, @NotNull TelemetryDto telemetry) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Intrinsics.checkParameterIsNotNull((Object)telemetry, (String)"telemetry");
        this.device = device;
        this.telemetry = telemetry;
        this.status = Status.STARTED.toString();
        this.semaphore = new Semaphore(1);
        this.semaphoreExhaustionCount = new AtomicLong(0L);
    }

    public /* synthetic */ PollingDriver(DeviceModel deviceModel, TelemetryDto telemetryDto, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            List list;
            long l = 0L;
            long l2 = 0L;
            String string = deviceModel.getName();
            String string2 = deviceModel.getInstanceId();
            boolean bl = false;
            List list2 = list = (List)new ArrayList();
            long l3 = l;
            long l4 = l2;
            MeasurementDto measurementDto = new MeasurementDto(l4, l3, list2);
            String string3 = string;
            String string4 = string2;
            telemetryDto = new TelemetryDto(string4, string3, measurementDto);
        }
        this(deviceModel, telemetryDto);
    }
}

