/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.modbus.rtu.master;

import io.gritlabs.probe.modbus.rtu.master.ModbusRtuMasterConfig;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.CommPortOwnershipListener;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

class SerialManager {
    private final int READ_HOLDING_REGISTER = 3;
    private final int READ_INPUT_CONTACTS = 2;
    private final int READ_INPUT_REGISTER = 4;
    private final int READ_OUTPUT_COILS = 1;
    private final int SIZE_CRCCODE = 2;
    private final int SIZE_DATACOUNT = 2;
    private final int SIZE_FIRSTADDRESS = 2;
    private final int SIZE_FUNCODE = 1;
    private final int SIZE_INITBUFFER = 8;
    private final int SIZE_NODATABYTE = 1;
    private final int SIZE_SLAVEID = 1;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    SerialManager() {
    }

    void addOwnerShipOfPort(CommPortIdentifier portId) {
        portId.addPortOwnershipListener((CommPortOwnershipListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    byte[] convertBufferToByteArray(ByteBuf buffer) {
        byte[] byteMsg = new byte[buffer.capacity()];
        for (int i = 0; i < buffer.capacity(); ++i) {
            byteMsg[i] = buffer.getByte(i);
        }
        return byteMsg;
    }

    ByteBuf createByteBuffer(int slaveId, int fcCode, int[] receivedValues, int[] crcCode, int size) {
        ByteBuf buffer = Unpooled.buffer((int)size);
        buffer.writeByte(slaveId);
        buffer.writeByte(fcCode);
        for (int i = 0; i < receivedValues.length; ++i) {
            buffer.writeByte(receivedValues[i]);
        }
        buffer.writeByte(crcCode[0]);
        buffer.writeByte(crcCode[1]);
        return buffer;
    }

    CommPortIdentifier getCommPortIdentifier(String portName) {
        try {
            return CommPortIdentifier.getPortIdentifier((String)portName);
        }
        catch (NoSuchPortException ex) {
            this.logger.error("Port with :" + portName + "is not available. Exception : " + (Object)((Object)ex));
            return null;
        }
    }

    public int getSIZE_CRCCODE() {
        return 2;
    }

    public int getSIZE_DATACOUNT() {
        return 2;
    }

    public int getSIZE_FIRSTADDRESS() {
        return 2;
    }

    public int getSIZE_FUNCODE() {
        return 1;
    }

    public int getSIZE_INITBUFFER() {
        return 8;
    }

    public int getSIZE_NODATABYTE() {
        return 1;
    }

    public int getSIZE_SLAVEID() {
        return 1;
    }

    InputStream getSerialPortInputStream(SerialPort serialPort) {
        try {
            return serialPort.getInputStream();
        }
        catch (IOException ex) {
            this.logger.error("IOExcepetion in getInputStream ex : " + ex);
            return null;
        }
    }

    OutputStream getSerialPortOutputStream(SerialPort serialPort) {
        try {
            return serialPort.getOutputStream();
        }
        catch (IOException ex) {
            this.logger.error("IOException in getOutputStream ex : " + ex);
            return null;
        }
    }

    SerialPort initSerialComm(ModbusRtuMasterConfig config) {
        CommPortIdentifier portId = this.getCommPortIdentifier(config.getPortName());
        if (portId == null) {
            this.logger.error("Error in getting Port Identifier for PostName : " + config.getPortName());
            return null;
        }
        this.addOwnerShipOfPort(portId);
        SerialPort serialPort = this.openSerialPort(portId, config.getTimeout());
        if (serialPort == null) {
            this.logger.error("Error in Opening Serial Port. Request Timeout");
            return null;
        }
        this.setFlowControlMode(serialPort, config.getFlowControl());
        this.setSerialPortParams(serialPort, config);
        return serialPort;
    }

    SerialPort openSerialPort(CommPortIdentifier portId, int timeout) {
        try {
            return (SerialPort)portId.open("Modbus", timeout);
        }
        catch (PortInUseException ex) {
            this.logger.error("Port in use exception ex : " + (Object)((Object)ex));
            return null;
        }
    }

    private void parseByteOrderedArray(int[] receivedValues, int noDataByte) {
        int noOf16BitsData = noDataByte / 2;
        for (int i = 2; i <= noOf16BitsData * 2; i += 2) {
            int temp = receivedValues[i];
            receivedValues[i] = receivedValues[i - 1];
            receivedValues[i - 1] = temp;
        }
    }

    private void parseWordOrderedArray(int[] receivedValues, int noDataByte) {
        int noOf32BitsData = noDataByte / 4;
        for (int i = 3; i <= noOf32BitsData * 4; ++i) {
            int temp = receivedValues[i];
            receivedValues[i] = receivedValues[i - 2];
            receivedValues[i - 2] = temp;
            if (i % 4 != 0) continue;
            i += 2;
        }
    }

    ByteBuf readResponseOnSerialPort(InputStream inputStream, ModbusRtuMasterConfig config) {
        int size = 0;
        ByteBuf buffer = null;
        try {
            int slaveId = inputStream.read();
            int fcCode = inputStream.read();
            this.logger.debug("SlaveId of the Response : " + slaveId + " with Function Code : " + fcCode);
            if (fcCode == 1 || fcCode == 2 || fcCode == 3 || fcCode == 4) {
                int noDataByte = inputStream.read();
                this.logger.debug("No. of Bytes to follow : " + noDataByte);
                int[] receivedValues = new int[noDataByte + 1];
                receivedValues[0] = noDataByte;
                for (int i = 1; i < receivedValues.length; ++i) {
                    receivedValues[i] = inputStream.read();
                }
                if (config.isLsbWordFirst() && (fcCode == 3 || fcCode == 4)) {
                    this.parseWordOrderedArray(receivedValues, noDataByte);
                }
                int[] crcCode = new int[2];
                for (int i = 0; i < 2; ++i) {
                    crcCode[i] = inputStream.read();
                }
                size = 3 + noDataByte + 2;
                buffer = this.createByteBuffer(slaveId, fcCode, receivedValues, crcCode, size);
            } else {
                int[] receivedValues = new int[4];
                for (int i = 0; i < receivedValues.length; ++i) {
                    receivedValues[i] = inputStream.read();
                }
                int[] crcCode = new int[2];
                for (int i = 0; i < 2; ++i) {
                    crcCode[i] = inputStream.read();
                }
                size = 8;
                buffer = this.createByteBuffer(slaveId, fcCode, receivedValues, crcCode, size);
            }
            return buffer;
        }
        catch (IOException ex) {
            this.logger.error("Error in Reading Ex : " + ex);
            return null;
        }
    }

    void sendRequestOutStream(OutputStream outputStream, byte[] msg) {
        try {
            outputStream.write(msg);
        }
        catch (IOException ex) {
            this.logger.error("IOException in sendRequestOutStream ex :" + ex);
        }
    }

    void setFlowControlMode(SerialPort serialPort, int flowcontrol) {
        try {
            serialPort.setFlowControlMode(flowcontrol);
        }
        catch (UnsupportedCommOperationException ex) {
            this.logger.error("UnsupportedCommOperationExcetion : ex - " + (Object)((Object)ex));
        }
    }

    void setSerialPortParams(SerialPort serialPort, ModbusRtuMasterConfig config) {
        try {
            serialPort.setSerialPortParams(config.getBaudRate(), config.getDataBits(), config.getStopBits(), config.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            this.logger.error("UnsupportedCommOperationException e : " + (Object)((Object)e));
        }
    }
}

