/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.driver.growatt;

import com.digitalpetri.modbus.requests.ModbusRequest;
import com.digitalpetri.modbus.requests.ReadHoldingRegistersRequest;
import io.gritlabs.probe.domain.driver.PollingDriver;
import io.gritlabs.probe.domain.driver.Status;
import io.gritlabs.probe.domain.driver.growatt.GrowattProtocol;
import io.gritlabs.probe.domain.service.dto.MeasurementDto;
import io.gritlabs.probe.domain.service.dto.PointDto;
import io.gritlabs.probe.domain.service.dto.PointTypeDto;
import io.gritlabs.probe.domain.service.model.DeviceModel;
import io.gritlabs.probe.domain.service.model.EventListener;
import io.gritlabs.probe.domain.service.model.EventRequestModel;
import io.gritlabs.probe.modbus.rtu.master.ModbusRtuMaster;
import io.gritlabs.probe.modbus.rtu.master.ModbusRtuMasterConfig;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionException;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0017J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020\u001cH\u0012J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020\u001cH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0092.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lio/gritlabs/probe/domain/driver/growatt/GrowattModBusDriver;", "Lio/gritlabs/probe/domain/driver/PollingDriver;", "Lio/gritlabs/probe/domain/service/model/EventListener;", "device", "Lio/gritlabs/probe/domain/service/model/DeviceModel;", "(Lio/gritlabs/probe/domain/service/model/DeviceModel;)V", "getDevice", "()Lio/gritlabs/probe/domain/service/model/DeviceModel;", "setDevice", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "master", "Lio/gritlabs/probe/modbus/rtu/master/ModbusRtuMaster;", "port", "", "getPort", "()Ljava/lang/String;", "setPort", "(Ljava/lang/String;)V", "updated", "Ljava/time/ZonedDateTime;", "getUpdated", "()Ljava/time/ZonedDateTime;", "setUpdated", "(Ljava/time/ZonedDateTime;)V", "destroy", "", "init", "onEventReceived", "eventRequestModel", "Lio/gritlabs/probe/domain/service/model/EventRequestModel;", "process", "queryAllRegisters", "queryRegister", "", "address", "validate", "grit-probe"})
public class GrowattModBusDriver
extends PollingDriver
implements EventListener {
    @NotNull
    private String port;
    @NotNull
    private ZonedDateTime updated;
    @NotNull
    private final Logger log;
    private ModbusRtuMaster master;
    @NotNull
    private DeviceModel device;

    public void process() {
        if (!this.getDevice().getEnabled()) {
            return;
        }
        try {
            this.queryAllRegisters();
        }
        catch (CompletionException e) {
            this.getLog().warn("Poll Completion Exception - [" + e.getMessage() + ']');
        }
        catch (Exception e) {
            this.getLog().error("Poll Exception - [" + e.getMessage() + ']', (Throwable)e);
        }
    }

    @NotNull
    public String getPort() {
        return this.port;
    }

    public void setPort(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.port = string;
    }

    public void validate() {
    }

    public void destroy() {
    }

    @NotNull
    public ZonedDateTime getUpdated() {
        return this.updated;
    }

    public void setUpdated(@NotNull ZonedDateTime zonedDateTime) {
        Intrinsics.checkParameterIsNotNull((Object)zonedDateTime, (String)"<set-?>");
        this.updated = zonedDateTime;
    }

    @NotNull
    public Logger getLog() {
        return this.log;
    }

    @PostConstruct
    public void init() {
        if (!this.getDevice().getEnabled()) {
            this.setStatus(Status.DISABLED.toString());
            return;
        }
        this.setPort(String.valueOf(this.getDevice().getParameters().get((Object)"port")));
        ModbusRtuMasterConfig modbusRtuMasterConfig = new ModbusRtuMasterConfig.Builder(this.getPort()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)modbusRtuMasterConfig, (String)"ModbusRtuMasterConfig.Builder(port).build()");
        ModbusRtuMasterConfig config = modbusRtuMasterConfig;
        this.master = new ModbusRtuMaster(config);
    }

    private void queryAllRegisters() {
        long start = Instant.now().toEpochMilli();
        boolean bl = false;
        List points = new ArrayList();
        int inverterStatus = this.queryRegister(0);
        String inverterStatusDisplay = GrowattProtocol.Companion.parseInverterStatus(String.valueOf(inverterStatus));
        points.add(new PointDto("InverterStatus", (Object)inverterStatusDisplay, PointTypeDto.STRING));
        int pvH = this.queryRegister(1);
        int pvL = this.queryRegister(2);
        int inputPower = ((pvH << 16) + pvL) / 10;
        points.add(new PointDto("MpptWatts", (Object)inputPower, PointTypeDto.DECIMAL));
        int pv1Voltage = this.queryRegister(3) / 10;
        points.add(new PointDto("Mppt1Voltage", (Object)pv1Voltage, PointTypeDto.DECIMAL));
        int pv1Curr = this.queryRegister(4) / 10;
        points.add(new PointDto("Mppt1Current", (Object)pv1Curr, PointTypeDto.DECIMAL));
        int pv1WattHigh = this.queryRegister(5);
        int pv1WattLow = this.queryRegister(6);
        int mppt1Watts = ((pv1WattHigh << 16) + pv1WattLow) / 10;
        points.add(new PointDto("Mppt1Watts", (Object)mppt1Watts, PointTypeDto.DECIMAL));
        int pv2Voltage = this.queryRegister(7) / 10;
        points.add(new PointDto("mppt2Voltage", (Object)pv2Voltage, PointTypeDto.DECIMAL));
        int pv2Curr = this.queryRegister(8) / 10;
        points.add(new PointDto("mppt2Current", (Object)pv2Curr, PointTypeDto.DECIMAL));
        int pv2WattHigh = this.queryRegister(9);
        int pv2WattLow = this.queryRegister(16);
        int mppt2Watts = ((pv2WattHigh << 16) + pv2WattLow) / 10;
        points.add(new PointDto("Mppt2Watts", (Object)mppt2Watts, PointTypeDto.DECIMAL));
        int pacH = this.queryRegister(17);
        int pacL = this.queryRegister(18);
        int outputPower = ((pacH << 16) + pacL) / 10;
        points.add(new PointDto("OutputPower", (Object)outputPower, PointTypeDto.DECIMAL));
        int fac = this.queryRegister(19) / 100;
        points.add(new PointDto("GridFrequency", (Object)fac, PointTypeDto.DECIMAL));
        int vac1 = this.queryRegister(20) / 10;
        points.add(new PointDto("Grid1Voltage", (Object)vac1, PointTypeDto.DECIMAL));
        int iac1 = this.queryRegister(21) / 10;
        points.add(new PointDto("Grid1Current", (Object)iac1, PointTypeDto.DECIMAL));
        int pac1H = this.queryRegister(22);
        int pac1L = this.queryRegister(23);
        int gridPower = ((pac1H << 16) + pac1L) / 10;
        points.add(new PointDto("Grid1Power", (Object)gridPower, PointTypeDto.DECIMAL));
        int vac2 = this.queryRegister(24) / 10;
        points.add(new PointDto("grid2Voltage", (Object)vac2, PointTypeDto.DECIMAL));
        int iac2 = this.queryRegister(25) / 10;
        points.add(new PointDto("grid2Current", (Object)iac2, PointTypeDto.DECIMAL));
        int pac2H = this.queryRegister(32);
        int pac2L = this.queryRegister(33);
        int grid2Power = ((pac2H << 16) + pac2L) / 10;
        points.add(new PointDto("Grid2Power", (Object)grid2Power, PointTypeDto.DECIMAL));
        int vac3 = this.queryRegister(34) / 10;
        points.add(new PointDto("Grid3Voltage", (Object)vac3, PointTypeDto.DECIMAL));
        int iac3 = this.queryRegister(35) / 10;
        points.add(new PointDto("Grid3Current", (Object)iac3, PointTypeDto.DECIMAL));
        int pac3H = this.queryRegister(36);
        int pac3L = this.queryRegister(37);
        int grid3Power = ((pac3H << 16) + pac3L) / 10;
        points.add(new PointDto("Grid3Power", (Object)grid3Power, PointTypeDto.DECIMAL));
        int energyProducedTodayHigh = this.queryRegister(38);
        int energyProducedTodayLow = this.queryRegister(39);
        int energyProducedToday = ((energyProducedTodayHigh << 16) + energyProducedTodayLow) / 10;
        points.add(new PointDto("EnergyProducedToday", (Object)energyProducedToday, PointTypeDto.DECIMAL));
        int energyProducedTotalHigh = this.queryRegister(40);
        int energyProducedTotalLow = this.queryRegister(41);
        int energyProducedTotal = ((energyProducedTotalHigh << 16) + energyProducedTotalLow) / 10;
        points.add(new PointDto("EnergyProducedTotal", (Object)energyProducedTotal, PointTypeDto.DECIMAL));
        int totalProductionTimeHigh = this.queryRegister(48);
        int totalProductionTimeLow = this.queryRegister(49);
        int totalProductionTime = ((totalProductionTimeHigh << 16) + totalProductionTimeLow) / 10;
        points.add(new PointDto("TotalProductionTime", (Object)totalProductionTime, PointTypeDto.DECIMAL));
        int temperature = this.queryRegister(50) / 10;
        points.add(new PointDto("temperature", (Object)temperature, PointTypeDto.DECIMAL));
        int faultCode = this.queryRegister(64);
        points.add(new PointDto("faultCode", (Object)GrowattProtocol.Companion.parseFaultCode(String.valueOf(faultCode)), PointTypeDto.STRING));
        int ipmTemp = this.queryRegister(65) / 10;
        points.add(new PointDto("ipmTemperature", (Object)ipmTemp, PointTypeDto.DECIMAL));
        int warningCode = this.queryRegister(100);
        points.add(new PointDto("warningCode", (Object)warningCode, PointTypeDto.DECIMAL));
        this.getTelemetry().setMeasurement(new MeasurementDto(Instant.now().toEpochMilli() - start, Instant.now().toEpochMilli(), points));
    }

    public int queryRegister(int address) {
        byte[] addressBuffer = ByteBuffer.allocate(4).putInt(address).array();
        try {
            int n;
            Logger logger = this.getLog();
            StringBuilder stringBuilder = new StringBuilder().append("Request: address=[0x");
            char[] cArray = Hex.encodeHex((byte[])addressBuffer);
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"Hex.encodeHex(addressBuffer)");
            char[] cArray2 = cArray;
            StringBuilder stringBuilder2 = stringBuilder;
            Logger logger2 = logger;
            boolean bl = false;
            String string = new String(cArray2);
            logger2.debug(stringBuilder2.append(string).append(']').toString());
            ModbusRtuMaster modbusRtuMaster = this.master;
            if (modbusRtuMaster == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"master");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(addressBuffer);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(addressBuffer)");
            ByteBuf response = modbusRtuMaster.sendRequest((ModbusRequest)new ReadHoldingRegistersRequest(byteBuffer.getInt(), 1), (byte)1);
            byte[] responseBuffer = response.array();
            switch (responseBuffer.length) {
                case 2: {
                    ByteBuffer byteBuffer2 = ByteBuffer.wrap(responseBuffer);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer2, (String)"ByteBuffer.wrap(responseBuffer)");
                    n = byteBuffer2.getShort();
                    break;
                }
                case 4: {
                    ByteBuffer byteBuffer3 = ByteBuffer.wrap(responseBuffer);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer3, (String)"ByteBuffer.wrap(responseBuffer)");
                    n = byteBuffer3.getInt();
                    break;
                }
                default: {
                    this.getLog().warn("Response Buffer Overflow: dataLength=[" + responseBuffer.length + ']');
                    return 0;
                }
            }
            int value = n;
            this.getLog().debug("Response: data=[" + value + ']');
            return value;
        }
        catch (ClosedChannelException e) {
            throw (Throwable)e;
        }
        catch (CompletionException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            Logger logger = this.getLog();
            StringBuilder stringBuilder = new StringBuilder().append("Query Register address=[0x");
            char[] cArray = Hex.encodeHex((byte[])addressBuffer);
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"Hex.encodeHex(addressBuffer)");
            char[] cArray3 = cArray;
            StringBuilder stringBuilder3 = stringBuilder;
            Logger logger3 = logger;
            boolean bl = false;
            String string = new String(cArray3);
            logger3.error(stringBuilder3.append(string).append("] ").append("Exception - [").append(e.getMessage()).append(']').toString(), (Throwable)e);
            throw (Throwable)e;
        }
    }

    public void onEventReceived(@NotNull EventRequestModel eventRequestModel) {
        Intrinsics.checkParameterIsNotNull((Object)eventRequestModel, (String)"eventRequestModel");
    }

    @NotNull
    public DeviceModel getDevice() {
        return this.device;
    }

    public void setDevice(@NotNull DeviceModel deviceModel) {
        Intrinsics.checkParameterIsNotNull((Object)deviceModel, (String)"<set-?>");
        this.device = deviceModel;
    }

    public GrowattModBusDriver(@NotNull DeviceModel device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        super(device, null, 2, null);
        this.device = device;
        this.port = "/dev/ttyUSB0";
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.now()");
        this.updated = zonedDateTime;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(this.javaClass)");
        this.log = logger;
    }
}

