/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.api;

import io.gritlabs.probe.api.EventController;
import io.gritlabs.probe.api.dto.EventDto;
import io.gritlabs.probe.domain.service.EventDispatcherService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lio/gritlabs/probe/api/EventControllerImpl;", "Lio/gritlabs/probe/api/EventController;", "eventService", "Lio/gritlabs/probe/domain/service/EventDispatcherService;", "(Lio/gritlabs/probe/domain/service/EventDispatcherService;)V", "getEventService", "()Lio/gritlabs/probe/domain/service/EventDispatcherService;", "postEvent", "Lorg/springframework/http/ResponseEntity;", "Ljava/lang/Void;", "event", "Lio/gritlabs/probe/api/dto/EventDto;", "grit-probe"})
public class EventControllerImpl
implements EventController {
    @NotNull
    private final EventDispatcherService eventService;

    @PostMapping(consumes={"application/json"}, value={"/event/queue"})
    @NotNull
    public ResponseEntity<Void> postEvent(@RequestBody @NotNull EventDto event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.getEventService().dispatch(event.getTopic(), event.getPayload());
        ResponseEntity responseEntity = ResponseEntity.accepted().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.accepted().build()");
        return responseEntity;
    }

    @NotNull
    public EventDispatcherService getEventService() {
        return this.eventService;
    }

    public EventControllerImpl(@NotNull EventDispatcherService eventService) {
        Intrinsics.checkParameterIsNotNull((Object)eventService, (String)"eventService");
        this.eventService = eventService;
    }
}

