/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.service;

import io.gritlabs.probe.domain.driver.PollingDriver;
import io.gritlabs.probe.domain.driver.Status;
import io.gritlabs.probe.domain.service.DeviceService;
import io.gritlabs.probe.domain.service.TelemetrySinkService;
import io.gritlabs.probe.domain.service.WorkerDispatcherService;
import io.gritlabs.probe.domain.service.WorkerDispatcherServiceImpl;
import io.gritlabs.probe.domain.service.model.DeviceModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B-\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0012J\b\u0010\u0019\u001a\u00020\u0016H\u0017J\b\u0010\u001a\u001a\u00020\u0016H\u0012J\b\u0010\u001b\u001a\u00020\u0016H\u0017J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/gritlabs/probe/domain/service/WorkerDispatcherServiceImpl;", "Lio/gritlabs/probe/domain/service/WorkerDispatcherService;", "deviceService", "Lio/gritlabs/probe/domain/service/DeviceService;", "telemetrySinkService", "Lio/gritlabs/probe/domain/service/TelemetrySinkService;", "interval", "", "maxSemaphoreAttempts", "(Lio/gritlabs/probe/domain/service/DeviceService;Lio/gritlabs/probe/domain/service/TelemetrySinkService;JJ)V", "active", "", "dispatchExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "supervisorExecutor", "workerExecutor", "checkAndResetDriverFailedLocks", "", "device", "Lio/gritlabs/probe/domain/service/model/DeviceModel;", "destroy", "dispatch", "init", "poll", "driver", "Lio/gritlabs/probe/domain/driver/PollingDriver;", "timeout", "process", "publish", "grit-probe"})
public class WorkerDispatcherServiceImpl
implements WorkerDispatcherService {
    private boolean active;
    private final ExecutorService dispatchExecutor;
    private final ExecutorService workerExecutor;
    private final ExecutorService supervisorExecutor;
    @NotNull
    private final Logger log;
    private final DeviceService deviceService;
    private final TelemetrySinkService telemetrySinkService;
    private final long interval;
    private final long maxSemaphoreAttempts;

    @PreDestroy
    public void destroy() {
        this.active = false;
    }

    @PostConstruct
    public void init() {
        this.getLog().debug("Dispatcher initializing...");
        this.supervisorExecutor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.getLog().debug("Dispatcher initialized...");
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void dispatch() {
        try {
            List list = this.deviceService.getEnabledDevices();
            if (list == null) {
                Intrinsics.throwNpe();
            }
            List devices2 = list.stream().filter((Predicate)dispatch.devices.1.INSTANCE).collect(Collectors.toList());
            while (this.active) {
                Collection<String> collection;
                Ref.ObjectRef $this$mapTo$iv$iv;
                void $this$map$iv;
                Thread.sleep(this.interval);
                Logger logger = this.getLog();
                StringBuilder stringBuilder = new StringBuilder().append("Polling... (every ").append(this.interval).append(" ms) ");
                List list2 = devices2;
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"devices");
                Iterable iterable = list2;
                StringBuilder stringBuilder2 = stringBuilder;
                Logger logger2 = logger;
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void device;
                    DeviceModel deviceModel = (DeviceModel)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string = device.getName() + ':' + device.getTimeout() + "ms";
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                logger2.debug(stringBuilder2.append(collection).toString());
                for (DeviceModel device : devices2) {
                    void workerThread;
                    $this$mapTo$iv$iv = new Ref.ObjectRef();
                    Intrinsics.checkExpressionValueIsNotNull((Object)Thread.currentThread(), (String)"Thread.currentThread()");
                    $this$mapTo$iv$iv.element = $this$mapTo$iv$iv.element;
                    try {
                        this.getLog().debug("Semaphore Acquisition (attempt) - " + device.getName() + " permits=[" + device.getDriver().getSemaphore().availablePermits() + "] ");
                        DeviceModel deviceModel = device;
                        Intrinsics.checkExpressionValueIsNotNull((Object)deviceModel, (String)"device");
                        this.checkAndResetDriverFailedLocks(deviceModel);
                        if (device.getDriver().acquire()) {
                            device.setInterval(this.interval);
                            this.getLog().info("Semaphore Acquired! - " + device.getName() + ' ' + "permits=[" + device.getDriver().getSemaphore().availablePermits() + ']');
                            this.dispatchExecutor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                        } else {
                            this.getLog().warn("No available permits:  " + device.getName() + ", acquisition attempts: " + device.getDriver().getSemaphoreExhaustionCount().incrementAndGet());
                        }
                    }
                    catch (Exception e) {
                        this.getLog().error("Dispatch Exception Worker[" + ((Thread)workerThread.element).getName() + "] : " + "javaClass" + ' ' + e.getMessage());
                        this.getLog().debug("Dispatch Exception Worker[" + ((Thread)workerThread.element).getName() + "] : " + "javaClass" + ' ' + e.getMessage(), (Throwable)e);
                    }
                    this.getLog().debug("Dispatch Complete - " + device.getName());
                }
            }
        }
        catch (Exception e) {
            this.getLog().error("Dispatcher Exception (Re-Init)", (Throwable)e);
            this.init();
        }
    }

    private void checkAndResetDriverFailedLocks(DeviceModel device) {
        if (device.getDriver().getSemaphoreExhaustionCount().get() >= this.maxSemaphoreAttempts) {
            if (device.getDriver().getSemaphore().availablePermits() < 1) {
                device.getDriver().release();
            }
            device.getDriver().destroy();
            device.getDriver().init();
            this.getLog().warn("Device re-initialized due to excessive failed locks/timeouts - " + device.getName() + " permits=[" + device.getDriver().getSemaphore().availablePermits() + "] ");
            device.getDriver().getSemaphoreExhaustionCount().set(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(@NotNull DeviceModel device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        this.getLog().debug("Processing: " + device.getName());
        try {
            device.getDriver().setStatus(Status.POLLING.toString());
            this.poll(device.getDriver(), device.getTimeout());
            device.getDriver().setStatus(Status.ONLINE.toString());
            this.publish(device);
        }
        catch (Exception e) {
            device.getDriver().setStatus(Status.OFFLINE.toString());
            this.getLog().error("Process Exception " + device.getName() + " - [" + e.getMessage() + ']', (Throwable)e);
        }
        finally {
            PollingDriver pollingDriver = device.getDriver();
            ZonedDateTime zonedDateTime = ZonedDateTime.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.now()");
            pollingDriver.setUpdated(zonedDateTime);
        }
        this.getLog().debug("Processing Done: " + device.getName());
    }

    private void publish(DeviceModel device) {
        this.telemetrySinkService.publish(device.getDriver().getTelemetry());
    }

    public void poll(@NotNull PollingDriver driver, long timeout) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this.getLog().debug("Submitted " + driver.getClass().getSimpleName() + " for execution with timeout of " + timeout + "ms...");
        driver.process();
    }

    @NotNull
    public Logger getLog() {
        return this.log;
    }

    public WorkerDispatcherServiceImpl(@Autowired @NotNull DeviceService deviceService, @Autowired @NotNull TelemetrySinkService telemetrySinkService, @Value(value="${grit.scheduler.poll.interval:5000}") long interval, @Value(value="${grit.scheduler.semaphoreLockAttempts:3}") long maxSemaphoreAttempts) {
        Intrinsics.checkParameterIsNotNull((Object)deviceService, (String)"deviceService");
        Intrinsics.checkParameterIsNotNull((Object)telemetrySinkService, (String)"telemetrySinkService");
        this.deviceService = deviceService;
        this.telemetrySinkService = telemetrySinkService;
        this.interval = interval;
        this.maxSemaphoreAttempts = maxSemaphoreAttempts;
        this.active = true;
        this.dispatchExecutor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("dispatch-"));
        this.workerExecutor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("worker-"));
        this.supervisorExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new CustomizableThreadFactory("dispatch-supervisor-"));
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(this.javaClass)");
        this.log = logger;
    }

    public static final /* synthetic */ void access$dispatch(WorkerDispatcherServiceImpl $this) {
        $this.dispatch();
    }

    public static final /* synthetic */ ExecutorService access$getWorkerExecutor$p(WorkerDispatcherServiceImpl $this) {
        return $this.workerExecutor;
    }
}

