/*
 * Decompiled with CFR 0.152.
 */
package io.gritlabs.probe.domain.service;

import io.gritlabs.probe.domain.service.HttpWebClientService;
import io.gritlabs.probe.domain.service.dto.TelemetryDto;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/gritlabs/probe/domain/service/HttpWebClientServiceImpl;", "Lio/gritlabs/probe/domain/service/HttpWebClientService;", "serverUrl", "", "enabled", "", "(Ljava/lang/String;Z)V", "client", "Lorg/springframework/web/client/RestTemplate;", "getClient", "()Lorg/springframework/web/client/RestTemplate;", "setClient", "(Lorg/springframework/web/client/RestTemplate;)V", "getEnabled", "()Z", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "publish", "", "telemetry", "Lio/gritlabs/probe/domain/service/dto/TelemetryDto;", "grit-probe"})
public class HttpWebClientServiceImpl
implements HttpWebClientService {
    @NotNull
    private final Logger log;
    @NotNull
    private RestTemplate client;
    private final String serverUrl;
    private final boolean enabled;

    @NotNull
    public Logger getLog() {
        return this.log;
    }

    @NotNull
    public RestTemplate getClient() {
        return this.client;
    }

    public void setClient(@NotNull RestTemplate restTemplate) {
        Intrinsics.checkParameterIsNotNull((Object)restTemplate, (String)"<set-?>");
        this.client = restTemplate;
    }

    public void publish(@NotNull TelemetryDto telemetry) {
        Intrinsics.checkParameterIsNotNull((Object)telemetry, (String)"telemetry");
        if (!this.getEnabled()) {
            return;
        }
        String url = this.serverUrl + "/telemetry";
        ResponseEntity responseEntity = this.getClient().postForEntity(url, (Object)telemetry, Void.class, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"client.postForEntity(url\u2026emetry, Void::class.java)");
        HttpStatus statusCode = responseEntity.getStatusCode();
        this.getLog().debug("WebClient [" + url + "] StatusCode=[" + statusCode.value() + ']');
        HttpStatus httpStatus = statusCode;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpStatus, (String)"statusCode");
        if (!httpStatus.is2xxSuccessful()) {
            throw (Throwable)new RuntimeException("WebClient Exception - Status: " + statusCode);
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public HttpWebClientServiceImpl(@Value(value="${grit.web.client.serverUrl:https://cloud.grobler.xyz/grit}") @NotNull String serverUrl, @Value(value="${grit.web.client.enabled:false}") boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)serverUrl, (String)"serverUrl");
        this.serverUrl = serverUrl;
        this.enabled = enabled;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(this.javaClass)");
        this.log = logger;
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).defaultHeader("Content-Type", new String[]{"application/json"}).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)restTemplate, (String)"RestTemplateBuilder()\n  \u2026LUE)\n            .build()");
        this.client = restTemplate;
    }
}

